/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.results;

import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFSDArrayList;
import it.jrc.lt.regexpfs.module.ModulePool;
import java.util.HashMap;

public class ResultPool {
    private int numberPhases = 0;
    private int currentPhase = 0;
    private ModulePool myModulePool;
    private InputFSDArrayList[] grammarOutput = null;
    private HashMap<String, InputFSArrayList>[] moduleOutput = null;
    private HashMap<String, Object>[] moduleNativeOutput = null;

    public void initialize(ModulePool modulePool, int numPhases) {
        this.myModulePool = modulePool;
        this.numberPhases = numPhases;
        this.currentPhase = 0;
        this.grammarOutput = new InputFSDArrayList[this.numberPhases];
        this.moduleOutput = new HashMap[this.numberPhases];
        this.moduleNativeOutput = new HashMap[this.numberPhases];
        for (int i = 0; i < numPhases; ++i) {
            this.grammarOutput[i] = new InputFSDArrayList();
            this.moduleOutput[i] = new HashMap();
            this.moduleNativeOutput[i] = new HashMap();
        }
    }

    public void clearPool() {
        if (this.grammarOutput == null) {
            return;
        }
        if (this.moduleOutput == null) {
            return;
        }
        if (this.moduleNativeOutput == null) {
            return;
        }
        for (int i = 0; i < this.numberPhases; ++i) {
            if (this.grammarOutput[i] != null) {
                this.grammarOutput[i].clear();
            }
            this.moduleOutput[i].clear();
            this.moduleNativeOutput[i].clear();
        }
        this.currentPhase = 0;
    }

    private ResultPool() {
    }

    public static ResultPool getInstance() {
        return new ResultPool();
    }

    public InputFSDArrayList[] getGrammarResults() {
        return this.grammarOutput;
    }

    public HashMap<String, InputFSArrayList>[] getModuleResults() {
        return this.moduleOutput;
    }

    public HashMap<String, Object>[] getModulesNativeResults() {
        return this.moduleNativeOutput;
    }

    public int getNumberPhases() {
        return this.numberPhases;
    }

    public InputFSDArrayList getGrammarResult(int index) {
        if (index < 0 || index >= this.numberPhases) {
            return null;
        }
        return this.grammarOutput[index];
    }

    public InputFSArrayList getModuleResult(String moduleName, int index) {
        if (index < 0 || index >= this.numberPhases) {
            return null;
        }
        HashMap<String, InputFSArrayList> lookIn = this.moduleOutput[index];
        if (lookIn == null) {
            return null;
        }
        return lookIn.get(moduleName);
    }

    public Object getModulesNativeResult(String moduleName, int index) {
        if (index < 0 || index >= this.numberPhases) {
            return null;
        }
        HashMap<String, Object> lookIn = this.moduleNativeOutput[index];
        if (lookIn == null) {
            return null;
        }
        return lookIn.get(moduleName);
    }

    public InputFSDArrayList getLastGrammarResult() {
        if (this.currentPhase < 0 || this.currentPhase >= this.numberPhases) {
            return null;
        }
        return this.grammarOutput[this.currentPhase];
    }

    public InputFSArrayList getCurrentResultsForModule(String moduleName) {
        if (this.currentPhase < 0 || this.currentPhase >= this.numberPhases) {
            return null;
        }
        HashMap<String, InputFSArrayList> lookIn = this.moduleOutput[this.currentPhase];
        return lookIn != null ? lookIn.get(moduleName) : null;
    }

    public Object getCurrentNativeResultsForModule(String moduleName) {
        if (this.currentPhase < 0 || this.currentPhase >= this.numberPhases) {
            return null;
        }
        HashMap<String, Object> lookIn = this.moduleNativeOutput[this.currentPhase];
        return lookIn != null ? lookIn.get(moduleName) : null;
    }

    public InputFSArrayList getMostRecentResultsForModule(String moduleName) {
        if (this.currentPhase < 0 || this.currentPhase >= this.numberPhases) {
            return null;
        }
        int phase = this.currentPhase;
        while (phase >= 0) {
            HashMap<String, InputFSArrayList> lookIn = this.moduleOutput[phase];
            if (lookIn == null) {
                --phase;
                continue;
            }
            InputFSArrayList result = lookIn.get(moduleName);
            if (result == null) {
                --phase;
                continue;
            }
            return result;
        }
        return null;
    }

    public Object getMostRecentNativeResultsForModule(String moduleName) {
        if (this.currentPhase < 0 || this.currentPhase >= this.numberPhases) {
            return null;
        }
        int phase = this.currentPhase;
        while (phase >= 0) {
            HashMap<String, Object> lookIn = this.moduleNativeOutput[phase];
            if (lookIn == null) {
                --phase;
                continue;
            }
            Object result = lookIn.get(moduleName);
            if (result == null) {
                --phase;
                continue;
            }
            return result;
        }
        return null;
    }

    public boolean addGrammarApplicationResult(InputFSDArrayList grammarResult, int phase) {
        if (phase < 0 || phase >= this.numberPhases) {
            return false;
        }
        this.grammarOutput[phase] = grammarResult;
        if (phase != this.currentPhase) {
            this.currentPhase = phase;
        }
        return true;
    }

    public boolean addModuleResult(String moduleName, InputFSArrayList moduleResult, int phase) {
        if (phase < 0 || phase >= this.numberPhases) {
            return false;
        }
        if (!this.myModulePool.isRegistered(moduleName)) {
            return false;
        }
        this.moduleOutput[phase].put(moduleName, moduleResult);
        if (phase != this.currentPhase) {
            this.currentPhase = phase;
        }
        return true;
    }

    public boolean addModuleNativeResult(String moduleName, Object moduleResult, int phase) {
        if (phase < 0 || phase >= this.numberPhases) {
            return false;
        }
        if (!this.myModulePool.isRegistered(moduleName)) {
            return false;
        }
        this.moduleNativeOutput[phase].put(moduleName, moduleResult);
        if (phase != this.currentPhase) {
            this.currentPhase = phase;
        }
        return true;
    }
}

