/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.ui;

import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.crawler.ui.CrawlerUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.WorkspaceFileEditorModel;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import it.jrc.osint.util.ui.Validators;
import it.jrc.osint.util.ui.WorkspaceFileEditor;
import it.jrc.osint.workspace.WorkspaceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CrawlerConfigEditor
extends WorkspaceFileEditor {
    private static final Logger log = LogManager.getLogger((String)CrawlerConfigEditor.class.getName());
    public static final String EDITOR_ID = "it.jrc.osint.crawler.ui.configEditor";
    private DataBindingContext m_bindingContext;
    private ListViewer listViewer;
    private org.eclipse.swt.widgets.List list;
    private CrawlerConfiguration model;
    private IInputValidator addValidator;
    private IInputValidator editValidator;
    private String selectedUrl;
    private ScrolledForm crawlerActionScrolledForm;
    private Text randomDelayText;
    private Text concurrentWorkersText;
    private Text maxDepthText;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FormToolkit toolkit;
    private Text excludePatternText;
    private Text includePatternText;

    public CrawlerConfigEditor() {
        super(CrawlerUIPlugin.getEventBroker());
    }

    protected WorkspaceFileEditorModel getEditorModel() {
        return this.model;
    }

    protected void loadModel(InputStream in) {
        this.model = CrawlerUIPlugin.getCrawlerService().loadConfiguration(in);
    }

    public boolean performSave(IFile file, IProgressMonitor monitor) {
        InputStream in = null;
        try {
            in = CrawlerUIPlugin.getCrawlerService().saveConfiguration(this.model);
            if (file.exists()) {
                file.setContents(in, 1, monitor);
            } else {
                file.create(in, true, monitor);
            }
            return true;
        }
        catch (CoreException e) {
            log.error("Failed to save crawler configuration", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("Failed to close input stream properly", (Throwable)e);
                }
            }
        }
        return false;
    }

    private IInputValidator getAddUrlValidator() {
        if (this.addValidator == null) {
            this.addValidator = Validators.notEmpty((String)"Please enter a non-empty string", (IInputValidator)Validators.notEqualsExistingValues((String)"URL already exists", (List)this.model.getSites(), (IInputValidator)Validators.isValidWebsiteURL((String)"Please enter a valid URL starting with http://")));
        }
        return this.addValidator;
    }

    private IInputValidator getEditUrlValidator() {
        if (this.editValidator == null) {
            this.editValidator = Validators.notEmpty((String)"Please enter a non-empty string", (IInputValidator)Validators.notEqualsExistingValues((String)"URL already exists", (List)this.model.getSites(), (String)this.selectedUrl, (IInputValidator)Validators.isValidWebsiteURL((String)"Please enter a valid URL starting with http://")));
        }
        return this.editValidator;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.crawlerActionScrolledForm = this.toolkit.createScrolledForm(parent);
        Composite body = this.crawlerActionScrolledForm.getBody();
        ColumnLayout columnLayout = new ColumnLayout();
        columnLayout.maxNumColumns = 1;
        body.setLayout((Layout)columnLayout);
        this.toolkit.paintBordersFor(body);
        Section targetedWebsitesSection = this.toolkit.createSection(body, 322);
        targetedWebsitesSection.setBackgroundMode(1);
        targetedWebsitesSection.setBackground(Display.getCurrent().getSystemColor(1));
        targetedWebsitesSection.setText("Targeted Websites");
        Composite targetUrlsComposite = this.toolkit.createComposite((Composite)targetedWebsitesSection, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        gridLayout_1.marginWidth = 0;
        targetUrlsComposite.setLayout((Layout)gridLayout_1);
        this.toolkit.paintBordersFor(targetUrlsComposite);
        targetedWebsitesSection.setClient((Control)targetUrlsComposite);
        Composite composite = this.toolkit.createComposite(targetUrlsComposite);
        composite.setLayout((Layout)new GridLayout());
        GridData gd_composite = new GridData(4, 4, true, true);
        gd_composite.heightHint = 0;
        gd_composite.widthHint = 0;
        composite.setLayoutData((Object)gd_composite);
        this.toolkit.paintBordersFor(composite);
        this.listViewer = new ListViewer(composite, 2560);
        this.list = this.listViewer.getList();
        this.list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.list.setRedraw(true);
        this.toolkit.adapt((Control)this.list, true, true);
        this.listViewer.setContentProvider((IContentProvider)new DefaultListContentProvider());
        this.listViewer.setInput((Object)this.model.getSites());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    CrawlerConfigEditor.this.selectedUrl = null;
                    CrawlerConfigEditor.this.editButton.setEnabled(false);
                    CrawlerConfigEditor.this.removeButton.setEnabled(false);
                } else {
                    CrawlerConfigEditor.this.selectedUrl = (String)selection.getFirstElement();
                    CrawlerConfigEditor.this.editButton.setEnabled(true);
                    CrawlerConfigEditor.this.removeButton.setEnabled(true);
                }
            }
        });
        TargetSiteDropListener targetSiteDropListener = new TargetSiteDropListener(this.listViewer, this.model);
        this.listViewer.addDropSupport(19, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)targetSiteDropListener);
        Composite buttonComposite = this.toolkit.createComposite(targetUrlsComposite, 0);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        buttonComposite.setLayout((Layout)fillLayout);
        this.toolkit.paintBordersFor(buttonComposite);
        this.addButton = this.toolkit.createButton(buttonComposite, "Add...", 0);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(CrawlerConfigEditor.this.getEditorSite().getShell(), "Add a new URL", "URL:", "", CrawlerConfigEditor.this.getAddUrlValidator());
                if (dialog.open() == 0) {
                    String term = dialog.getValue().trim();
                    CrawlerConfigEditor.this.model.addSite(term);
                    CrawlerConfigEditor.this.listViewer.refresh();
                }
            }
        });
        this.editButton = this.toolkit.createButton(buttonComposite, "Edit...", 0);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(CrawlerConfigEditor.this.getEditorSite().getShell(), "Edit Website URL", "Edit URL:", CrawlerConfigEditor.this.selectedUrl, CrawlerConfigEditor.this.getEditUrlValidator());
                if (dialog.open() == 0) {
                    String changedItem = dialog.getValue().trim();
                    int indexOfSelectedUrl = CrawlerConfigEditor.this.model.getSites().indexOf(CrawlerConfigEditor.this.selectedUrl);
                    if (indexOfSelectedUrl != -1) {
                        CrawlerConfigEditor.this.model.setSite(indexOfSelectedUrl, changedItem);
                    }
                    CrawlerConfigEditor.this.listViewer.refresh();
                }
            }
        });
        this.removeButton = this.toolkit.createButton(buttonComposite, "Remove", 0);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection i = (IStructuredSelection)CrawlerConfigEditor.this.listViewer.getSelection();
                String item = (String)i.getFirstElement();
                CrawlerConfigEditor.this.model.removeSite(item);
                CrawlerConfigEditor.this.listViewer.refresh();
            }
        });
        this.crawlerActionScrolledForm.setText("Crawler Configuration");
        Section crawlParametersSection = this.toolkit.createSection(body, 258);
        crawlParametersSection.setText("Crawl Parameters");
        crawlParametersSection.setExpanded(true);
        Composite crawlParamComposite = this.toolkit.createComposite((Composite)crawlParametersSection, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        crawlParamComposite.setLayout((Layout)gridLayout_2);
        this.toolkit.paintBordersFor(crawlParamComposite);
        crawlParametersSection.setClient((Control)crawlParamComposite);
        this.toolkit.createLabel(crawlParamComposite, "Max Depth", 0);
        this.maxDepthText = this.toolkit.createText(crawlParamComposite, null, 0);
        this.maxDepthText.setText("1");
        this.maxDepthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolkit.createLabel(crawlParamComposite, "Concurrent Workers", 0);
        this.concurrentWorkersText = this.toolkit.createText(crawlParamComposite, null, 0);
        this.concurrentWorkersText.setToolTipText("Number of concurrent downloads");
        this.concurrentWorkersText.setText("1");
        this.concurrentWorkersText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolkit.createLabel(crawlParamComposite, "Random Delay (ms)", 0);
        this.randomDelayText = this.toolkit.createText(crawlParamComposite, null, 0);
        this.randomDelayText.setToolTipText("Minimal delay between requests");
        this.randomDelayText.setText("2500");
        this.randomDelayText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label includePatternLabel = this.toolkit.createLabel(crawlParamComposite, "Include URL Pattern", 0);
        includePatternLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.includePatternText = new Text(crawlParamComposite, 2048);
        this.includePatternText.setToolTipText("Include all URLs which match a regular pattern");
        this.includePatternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.adapt((Control)this.includePatternText, true, true);
        Label excludePatternLabel = new Label(crawlParamComposite, 0);
        excludePatternLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.toolkit.adapt((Control)excludePatternLabel, true, true);
        excludePatternLabel.setText("Exclude URL Pattern");
        this.excludePatternText = this.toolkit.createText(crawlParamComposite, null, 0);
        this.excludePatternText.setToolTipText("Exclude all URLs which match a regular pattern");
        this.excludePatternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_bindingContext = this.initDataBindings();
    }

    public void setFocus() {
        this.crawlerActionScrolledForm.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.toolkit.dispose();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue maxDepthTextTextObserveWidget = SWTObservables.observeText((Control)this.maxDepthText, (int)24);
        IObservableValue modelMaxDepthObserveValue = BeansObservables.observeValue((Object)this.model, (String)"maxDepth");
        bindingContext.bindValue((IObservableValue)maxDepthTextTextObserveWidget, modelMaxDepthObserveValue, null, null);
        ISWTObservableValue concurrentWorkersTextTextObserveWidget = SWTObservables.observeText((Control)this.concurrentWorkersText, (int)24);
        IObservableValue modelWorkersPerSiteObserveValue = BeansObservables.observeValue((Object)this.model, (String)"workersPerSite");
        bindingContext.bindValue((IObservableValue)concurrentWorkersTextTextObserveWidget, modelWorkersPerSiteObserveValue, null, null);
        ISWTObservableValue randomDelayTextTextObserveWidget = SWTObservables.observeText((Control)this.randomDelayText, (int)24);
        IObservableValue modelRandomDelayMsObserveValue = BeansObservables.observeValue((Object)this.model, (String)"randomDelayMs");
        bindingContext.bindValue((IObservableValue)randomDelayTextTextObserveWidget, modelRandomDelayMsObserveValue, null, null);
        ISWTObservableValue observeTextExcludePatternTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.excludePatternText);
        IObservableValue excludePatternModelObserveValue = BeanProperties.value((String)"excludePattern").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextExcludePatternTextObserveWidget, excludePatternModelObserveValue, null, null);
        ISWTObservableValue observeTextIncludePatternTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.includePatternText);
        IObservableValue includePatternModelObserveValue = BeanProperties.value((String)"includePattern").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextIncludePatternTextObserveWidget, includePatternModelObserveValue, null, null);
        return bindingContext;
    }

    private static class DefaultListContentProvider
    extends StructuredContentProviderAdapter {
        private DefaultListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List v = (List)inputElement;
            return v.toArray();
        }
    }

    public class TargetSiteDropListener
    extends ViewerDropAdapter {
        private final ListViewer listViewer;
        private final CrawlerConfiguration model;

        public TargetSiteDropListener(ListViewer listViewer, CrawlerConfiguration model) {
            super((Viewer)listViewer);
            this.listViewer = listViewer;
            this.model = model;
        }

        public void drop(DropTargetEvent event) {
            IStructuredSelection structuredSelection;
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (structuredSelection = (IStructuredSelection)event.data) != null && !structuredSelection.isEmpty()) {
                for (Object selectedObject : structuredSelection) {
                    if (!(selectedObject instanceof IFile)) continue;
                    this.addTargetSiteFromBookmarkFile((IFile)selectedObject);
                }
            }
            super.drop(event);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TargetSiteDropListener.this.listViewer.refresh();
                }
            });
        }

        private void addTargetSiteFromBookmarkFile(IFile aFile) {
            if (aFile == null) {
                return;
            }
            String contentTypeId = WorkspaceUtil.getContentTypeId((IFile)aFile);
            if (contentTypeId != null && contentTypeId.equals("it.jrc.osint.contenttype.URLBookmark")) {
                SearchService ss = CrawlerUIPlugin.getSearchService();
                try {
                    URLBookmark bookmark = ss.loadBookmark(aFile.getContents());
                    this.model.addSite(bookmark.getURL());
                }
                catch (Throwable t) {
                    log.error("Failed to drop file into target site list", t);
                }
                return;
            }
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }

        public boolean performDrop(Object data) {
            return true;
        }
    }
}

