/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.ui.handler;

import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.crawler.CrawlerService;
import it.jrc.osint.crawler.ui.CrawlerUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.DateUtil;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class PerformCrawlHandler
extends AbstractHandler
implements IHandler {
    private static final Logger log = LogManager.getLogger((String)PerformCrawlHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CaseProject cp;
        TreePath[] paths;
        block7: {
            IProject project;
            block6: {
                block5: {
                    try {
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                        ISelection selection = window.getSelectionService().getSelection();
                        TreeSelection treeSelection = (TreeSelection)selection;
                        paths = treeSelection.getPaths();
                        if (paths != null) break block5;
                        return null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new ExecutionException("Failed to perform crawl operation", t);
                    }
                }
                project = (IProject)paths[0].getFirstSegment();
                if (project.isAccessible()) break block6;
                log.warn("Handler called on closed or non-existing project");
                return null;
            }
            cp = this.getWorkspaceService().getCaseProjectByName(project.getName());
            if (cp != null) break block7;
            return null;
        }
        IFile crawlerConfigFile = (IFile)paths[0].getLastSegment();
        CrawlerService crawlerService = CrawlerUIPlugin.getCrawlerService();
        CrawlerConfiguration config = crawlerService.loadConfiguration(crawlerConfigFile.getContents());
        String fileName = crawlerConfigFile.getName();
        int index = fileName.indexOf(".occ");
        fileName = fileName.substring(0, index);
        String operationName = String.valueOf(fileName) + "_" + DateUtil.getFormattedFileSuffixDate((Date)new Date());
        crawlerService.crawl(config, operationName, cp);
        return null;
    }

    private WorkspaceService getWorkspaceService() {
        return CrawlerUIPlugin.getWorkspaceService();
    }
}

