/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.crawler.ui.wizard;

import it.jrc.osint.crawler.CrawlerConfiguration;
import it.jrc.osint.crawler.CrawlerService;
import it.jrc.osint.crawler.ui.CrawlerUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationResult;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.ui.wizard.WizardNewFileCreationPage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class NewCrawlerConfigCreationPage
extends WizardNewFileCreationPage {
    private static final Logger log = LogManager.getLogger((String)NewCrawlerConfigCreationPage.class.getName());
    private CrawlerConfiguration initialCrawlerConfiguration;

    public NewCrawlerConfigCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setTitle("OSINT Crawler Configuration");
        this.setDescription("Create a new Crawler Configuration");
        this.setFileExtension("occ");
    }

    public IFile createNewFile(String importBookmarkFilePath) {
        SearchService ss;
        OperationResult importedBookmarkResult;
        if (importBookmarkFilePath != null && (importedBookmarkResult = (ss = CrawlerUIPlugin.getSearchService()).getImporter().importBookmarksFromTSVFile(importBookmarkFilePath)).isOk()) {
            this.initialCrawlerConfiguration = this.createCrawlerConfiguration();
            this.initialCrawlerConfiguration.getSites().addAll(this.getURLs((List)importedBookmarkResult.getResult()));
        }
        return super.createNewFile();
    }

    private List<String> getURLs(List<URLBookmark> bookmarks) {
        if (bookmarks == null) {
            return Collections.emptyList();
        }
        ArrayList<String> resultURLs = new ArrayList<String>();
        for (URLBookmark bm : bookmarks) {
            resultURLs.add(bm.getURL());
        }
        return resultURLs;
    }

    protected InputStream getInitialContents() {
        CrawlerService cs = CrawlerUIPlugin.getCrawlerService();
        if (this.initialCrawlerConfiguration == null) {
            this.initialCrawlerConfiguration = this.createCrawlerConfiguration();
        }
        return cs.saveConfiguration(this.initialCrawlerConfiguration);
    }

    private CrawlerConfiguration createCrawlerConfiguration() {
        CrawlerService cs = CrawlerUIPlugin.getCrawlerService();
        return cs.createConfiguration();
    }
}

