/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.editor;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.LinkExtractorDescription;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.WorkspaceFileEditorModel;
import it.jrc.osint.util.ui.WorkspaceFileEditor;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;

public class LinkExtractionDescriptionEditor
extends WorkspaceFileEditor {
    private static final Logger log = LogManager.getLogger((String)LinkExtractionDescriptionEditor.class.getName());
    public static final String EDITOR_ID = "it.jrc.osint.search.ui.linkExtractorDescriptionEditor";
    private DataBindingContext m_bindingContext;
    private LinkExtractorDescription model;
    private ScrolledForm ledActionScrolledForm;
    private Text resultLinkExprText;
    private Text nextResultPageExprText;
    private FormToolkit toolkit;
    private Text nameText;
    private Text homePageText;
    private Text extractURLPatternText;
    private Text searchQueryExprText;
    private Button siteAlreadyJQueryButton;
    private Text text;

    public LinkExtractionDescriptionEditor() {
        super(SearchUIPlugin.getPlugin().getEventBroker());
    }

    protected WorkspaceFileEditorModel getEditorModel() {
        return this.model;
    }

    protected void loadModel(InputStream in) {
        this.model = SearchPlugin.getSearchService().loadLinkExtractorDescription(in);
    }

    public boolean performSave(IFile file, IProgressMonitor monitor) {
        InputStream in = null;
        try {
            in = SearchPlugin.getSearchService().saveLinkExtractorDescription(this.model);
            if (file.exists()) {
                file.setContents(in, 1, monitor);
            } else {
                file.create(in, true, monitor);
            }
            this.performRefreshToolsViewCommand();
            return true;
        }
        catch (CoreException e) {
            log.error("Failed to save crawler configuration", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("Failed to close input stream properly", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void performRefreshToolsViewCommand() {
        try {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            handlerService.executeCommand("it.jrc.osint.ui.command.refreshToolsView", null);
        }
        catch (Throwable t) {
            log.error("Failed to refresh tools view after save of LED editor", t);
        }
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.ledActionScrolledForm = this.toolkit.createScrolledForm(parent);
        Composite body = this.ledActionScrolledForm.getBody();
        ColumnLayout columnLayout = new ColumnLayout();
        columnLayout.maxNumColumns = 1;
        body.setLayout((Layout)columnLayout);
        this.toolkit.paintBordersFor(body);
        Section basicSection = this.toolkit.createSection(body, 322);
        basicSection.setBackgroundMode(1);
        basicSection.setBackground(Display.getCurrent().getSystemColor(1));
        basicSection.setText("Basic");
        Composite targetUrlsComposite = this.toolkit.createComposite((Composite)basicSection, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        gridLayout_1.marginWidth = 0;
        targetUrlsComposite.setLayout((Layout)gridLayout_1);
        this.toolkit.paintBordersFor(targetUrlsComposite);
        basicSection.setClient((Control)targetUrlsComposite);
        Label nameLabel = this.toolkit.createLabel(targetUrlsComposite, "Name", 0);
        nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.nameText = this.toolkit.createText(targetUrlsComposite, "New Text", 0);
        this.nameText.setText("");
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label homePageLabel = this.toolkit.createLabel(targetUrlsComposite, "Homepage URL", 0);
        homePageLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.homePageText = this.toolkit.createText(targetUrlsComposite, "New Text", 0);
        this.homePageText.setText("");
        this.homePageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label extractURLPatternLabel = this.toolkit.createLabel(targetUrlsComposite, "Matches URL", 0);
        extractURLPatternLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.extractURLPatternText = this.toolkit.createText(targetUrlsComposite, "New Text", 0);
        this.extractURLPatternText.setText("");
        this.extractURLPatternText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Section jqueryParametersSection = this.toolkit.createSection(body, 322);
        jqueryParametersSection.setText("Result Extraction (JQuery Selector Expressions)");
        jqueryParametersSection.setExpanded(true);
        Composite jqueryParamComposite = this.toolkit.createComposite((Composite)jqueryParametersSection, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 2;
        jqueryParamComposite.setLayout((Layout)gridLayout_2);
        this.toolkit.paintBordersFor(jqueryParamComposite);
        jqueryParametersSection.setClient((Control)jqueryParamComposite);
        Label searchQueryExprLabel = new Label(jqueryParamComposite, 0);
        searchQueryExprLabel.setToolTipText("expression to select input tag containing the search query");
        searchQueryExprLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.toolkit.adapt((Control)searchQueryExprLabel, true, true);
        searchQueryExprLabel.setText("Query Input Field");
        this.searchQueryExprText = new Text(jqueryParamComposite, 2048);
        this.searchQueryExprText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.toolkit.adapt((Control)this.searchQueryExprText, true, true);
        Label resultLinkExprLabel = this.toolkit.createLabel(jqueryParamComposite, "Result Links", 0);
        resultLinkExprLabel.setToolTipText("expression to find a tag of result links in document");
        resultLinkExprLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.resultLinkExprText = this.toolkit.createText(jqueryParamComposite, null, 0);
        this.resultLinkExprText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label nextResultPageExprLabel = this.toolkit.createLabel(jqueryParamComposite, "Next Page", 0);
        nextResultPageExprLabel.setToolTipText("expression to find a tag of link to next page");
        nextResultPageExprLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.nextResultPageExprText = this.toolkit.createText(jqueryParamComposite, null, 0);
        this.nextResultPageExprText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblContainsJquery = new Label(jqueryParamComposite, 0);
        this.toolkit.adapt((Control)lblContainsJquery, true, true);
        lblContainsJquery.setText("Contains JQuery");
        this.siteAlreadyJQueryButton = new Button(jqueryParamComposite, 32);
        this.toolkit.adapt((Control)this.siteAlreadyJQueryButton, true, true);
        Section linkExtractScriptSection = this.toolkit.createSection(body, 322);
        linkExtractScriptSection.setText("Script to process and filter result links");
        linkExtractScriptSection.setExpanded(true);
        Composite linkExtractScriptComposite = this.toolkit.createComposite((Composite)linkExtractScriptSection, 0);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 2;
        linkExtractScriptComposite.setLayout((Layout)gridLayout_3);
        this.toolkit.paintBordersFor(linkExtractScriptComposite);
        linkExtractScriptSection.setClient((Control)linkExtractScriptComposite);
        Label lblScript = new Label(linkExtractScriptComposite, 0);
        lblScript.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.toolkit.adapt((Control)lblScript, true, true);
        lblScript.setText("GroovyScript");
        this.text = new Text(linkExtractScriptComposite, 2882);
        GridData gd_text = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_text.heightHint = 10 * this.text.getLineHeight();
        this.text.setLayoutData((Object)gd_text);
        this.toolkit.adapt((Control)this.text, true, true);
        this.ledActionScrolledForm.setText("Link Extractor Description");
        this.m_bindingContext = this.initDataBindings();
    }

    public void setFocus() {
        this.ledActionScrolledForm.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.toolkit.dispose();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue nameTextObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.nameText);
        IObservableValue modelNameObserveValue = BeanProperties.value((String)"name").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)nameTextObserveTextObserveWidget, modelNameObserveValue, null, null);
        ISWTObservableValue homePageTextObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.homePageText);
        IObservableValue modelHomePageURLObserveValue = BeanProperties.value((String)"homePageURL").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)homePageTextObserveTextObserveWidget, modelHomePageURLObserveValue, null, null);
        ISWTObservableValue extractURLPatternTextObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.extractURLPatternText);
        IObservableValue modelExtractURLPatternObserveValue = BeanProperties.value((String)"extractURLPattern").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)extractURLPatternTextObserveTextObserveWidget, modelExtractURLPatternObserveValue, null, null);
        ISWTObservableValue observeTextNextResultPageExprTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.nextResultPageExprText);
        IObservableValue nextPageJQuerySelectorModelObserveValue = BeanProperties.value((String)"nextPageJQuerySelector").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextNextResultPageExprTextObserveWidget, nextPageJQuerySelectorModelObserveValue, null, null);
        ISWTObservableValue observeTextResultLinkExprTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.resultLinkExprText);
        IObservableValue resultLinkJQuerySelectorModelObserveValue = BeanProperties.value((String)"resultLinkJQuerySelector").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextResultLinkExprTextObserveWidget, resultLinkJQuerySelectorModelObserveValue, null, null);
        ISWTObservableValue observeTextSearchQueryExprTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.searchQueryExprText);
        IObservableValue searchQueryJQuerySelectorModelObserveValue = BeanProperties.value((String)"searchQueryJQuerySelector").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextSearchQueryExprTextObserveWidget, searchQueryJQuerySelectorModelObserveValue, null, null);
        ISWTObservableValue observeSiteAlreadyJQueryButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.siteAlreadyJQueryButton);
        IObservableValue alreadyJQueryModelObserveValue = BeanProperties.value((String)"siteAlreadyJQuery").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeSiteAlreadyJQueryButtonObserveWidget, alreadyJQueryModelObserveValue);
        ISWTObservableValue observeTextTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        IObservableValue extractResultURLScriptModelObserveValue = BeanProperties.value((String)"extractResultURLScript").observe((Object)this.model);
        bindingContext.bindValue((IObservableValue)observeTextTextObserveWidget, extractResultURLScriptModelObserveValue, null, null);
        return bindingContext;
    }
}

