/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.ui.navigator.ProjectExplorerUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteDuplicateBookmarksHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)DeleteDuplicateBookmarksHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            TreePath[] paths;
            IWorkbenchWindow window;
            block5: {
                window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                ISelection selection = window.getSelectionService().getSelection();
                TreeSelection treeSelection = (TreeSelection)selection;
                paths = treeSelection.getPaths();
                if (paths != null && paths.length >= 1) break block5;
                log.warn("Selection is null or empty");
                return null;
            }
            try {
                TreePath aTreePath = paths[0];
                Object lastSegment = aTreePath.getLastSegment();
                if (lastSegment instanceof IFolder) {
                    boolean confirmed = MessageDialog.openConfirm((Shell)window.getShell(), (String)"Confirm Delete", (String)"Do you want to delete all duplicate bookmarks?");
                    if (confirmed) {
                        IFolder startFolder = (IFolder)lastSegment;
                        SearchService ss = SearchUIPlugin.getSearchService();
                        ss.deleteDuplicateBookmarks(startFolder);
                        ProjectExplorerUtil.refresh();
                    }
                    break block6;
                }
                log.warn("Could not find folder containing urls");
                return null;
            }
            catch (Throwable t) {
                log.error("Failed to start http grabber", t);
            }
        }
        return null;
    }
}

