/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.grabber.GrabberPlugin;
import it.jrc.osint.grabber.GrabberService;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class DownloadURLsHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)DownloadURLsHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CaseProject targetProject;
        TreePath aTreePath;
        block9: {
            IProject project;
            block8: {
                TreePath[] paths;
                block7: {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                    ISelection selection = window.getSelectionService().getSelection();
                    TreeSelection treeSelection = (TreeSelection)selection;
                    paths = treeSelection.getPaths();
                    if (paths != null && paths.length >= 1) break block7;
                    log.warn("Selection is null or empty");
                    return null;
                }
                aTreePath = paths[0];
                project = (IProject)aTreePath.getFirstSegment();
                if (project != null && project.isAccessible()) break block8;
                log.warn("Handler called on closed or not existing project");
                return null;
            }
            targetProject = this.getWorkspaceService().getCaseProjectByName(project.getName());
            if (targetProject != null) break block9;
            log.error("Could not find case project");
            return null;
        }
        Object lastSegment = aTreePath.getLastSegment();
        String operationName = null;
        List bookmarks = null;
        if (!(lastSegment instanceof IFolder)) {
            log.warn("Could not find folder containing urls");
            return null;
        }
        IFolder inputFolder = (IFolder)lastSegment;
        SearchService ss = SearchUIPlugin.getSearchService();
        bookmarks = ss.loadBookmarks(inputFolder);
        operationName = inputFolder.getName();
        try {
            GrabberService gs = GrabberPlugin.getGrabberService();
            gs.grab(bookmarks, operationName, targetProject);
        }
        catch (Throwable t) {
            log.error("Failed to start http grabber", t);
        }
        return null;
    }

    private WorkspaceService getWorkspaceService() {
        return SearchUIPlugin.getWorkspaceService();
    }
}

