/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.workspace.CaseProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindDuplicateBookmarksHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)FindDuplicateBookmarksHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block6: {
            TreePath[] paths;
            block5: {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                ISelection selection = window.getSelectionService().getSelection();
                TreeSelection treeSelection = (TreeSelection)selection;
                paths = treeSelection.getPaths();
                if (paths != null && paths.length >= 1) break block5;
                log.warn("Selection is null or empty");
                return null;
            }
            try {
                TreePath aTreePath = paths[0];
                Object lastSegment = aTreePath.getLastSegment();
                if (lastSegment instanceof IFolder) {
                    IFolder folder = (IFolder)lastSegment;
                    if (folder != null) {
                        CaseProject cp = SearchUIPlugin.getWorkspaceService().getCaseProjectByName(folder.getProject().getName());
                        SearchService ss = SearchUIPlugin.getSearchService();
                        ss.findDuplicateBookmarks(cp);
                    }
                    break block6;
                }
                log.warn("Could not find folder containing urls");
                return null;
            }
            catch (Throwable t) {
                log.error("Failed to start http grabber", t);
            }
        }
        return null;
    }
}

