/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ResourceId {
    private static final String NULL_ID_STR = "null-resource-id";
    public static final ResourceId NULL_ID = new ResourceId("null-resource-id");
    private String id;

    public ResourceId() {
        UUID uuid = UUID.randomUUID();
        this.id = uuid.toString();
    }

    public ResourceId(String id) {
        this.id = id;
    }

    public static ResourceId fromString(String resourceIdStr) {
        return new ResourceId(resourceIdStr);
    }

    public static List<ResourceId> toTypedList(List<String> docIds) {
        ArrayList<ResourceId> docIdsList = new ArrayList<ResourceId>();
        for (String docId : docIds) {
            docIdsList.add(new ResourceId(docId));
        }
        return docIdsList;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ResourceId) {
            ResourceId otherId = (ResourceId)other;
            return otherId.id.equals(this.id);
        }
        return false;
    }

    public boolean isNull() {
        return this.id.equals(NULL_ID_STR);
    }
}

