/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.operations;

import it.jrc.osint.operations.ErrorCondition;

public class OperationStatus {
    public static final int OK = 0;
    public static final int ERROR = 4;
    public static final int CANCEL = 8;
    public static final OperationStatus OK_STATUS = new OperationStatus(0);
    public static final OperationStatus CANCEL_STATUS = new OperationStatus(8);
    private int severity = 0;
    private ErrorCondition errorCondition;

    public OperationStatus(int severity) {
        this.setSeverity(severity);
    }

    public OperationStatus(int severity, ErrorCondition errorCondition) {
        this.setSeverity(severity);
        this.setErrorCondition(errorCondition);
    }

    public OperationStatus(ErrorCondition errorCondition) {
        this.setSeverity(4);
        this.setErrorCondition(errorCondition);
    }

    @Deprecated
    public static OperationStatus createErrorStatus(String message, Throwable cause) {
        OperationStatus errorStatus = new OperationStatus(4, new ErrorCondition(0, message, "", cause));
        return errorStatus;
    }

    @Deprecated
    public static OperationStatus createErrorStatus(String message) {
        return OperationStatus.createErrorStatus(message, null);
    }

    protected void setSeverity(int severity) {
        this.severity = severity;
    }

    protected void setErrorCondition(ErrorCondition errorCondition) {
        this.errorCondition = errorCondition;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean isCancel() {
        return this.severity == 8;
    }

    public boolean isError() {
        return this.severity == 4;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    public Throwable getException() {
        return this.errorCondition.getException();
    }

    public ErrorCondition getErrorCondition() {
        return this.errorCondition;
    }

    public String getMessage() {
        return this.errorCondition.getMessage();
    }

    public int getErrorCode() {
        return this.errorCondition.getCode();
    }

    public String toString() {
        switch (this.severity) {
            case 8: {
                return "CANCEL";
            }
            case 4: {
                return "ERROR:" + this.getMessage() + ":" + this.getErrorCode() + ";" + this.getException();
            }
        }
        return "OK";
    }
}

