/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui;

import it.jrc.osint.extract.entities.BuiltInEntityTypes;
import it.jrc.osint.extract.ui.TextAnnotation;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextAnnotationModel {
    private static final Logger log = LogManager.getLogger((String)TextAnnotationModel.class.getName());
    private static final String TITLE_TEXT_SEPARATOR = ". ";
    public static final TextAnnotationModel EMPTY_MODEL = new TextAnnotationModel(0, 0);
    private NavigableMap<Integer, Set<TextAnnotation>> annotationMap = new TreeMap<Integer, Set<TextAnnotation>>();
    private int textLength;
    private int titleLength;

    public TextAnnotationModel(int textLength, int titleLength) {
        this.textLength = textLength;
        this.titleLength = titleLength > 0 ? titleLength + TITLE_TEXT_SEPARATOR.length() : 0;
    }

    public void add(TextAnnotation anAnnotation) {
        if (this.insideTitle(anAnnotation)) {
            log.debug("Annotation of type " + anAnnotation.getType().toString() + " inside title area, not added");
            return;
        }
        this.adjustCharPosToTitleLength(anAnnotation);
        if (this.insideText(anAnnotation)) {
            HashSet<TextAnnotation> annotations = (HashSet<TextAnnotation>)this.annotationMap.get(anAnnotation.getCharPos());
            if (annotations == null) {
                annotations = new HashSet<TextAnnotation>();
                annotations.add(anAnnotation);
                this.annotationMap.put(anAnnotation.getCharPos(), annotations);
            } else {
                annotations.add(anAnnotation);
            }
        }
    }

    private boolean insideText(TextAnnotation anAnnotation) {
        int charPos = anAnnotation.getCharPos();
        int length = anAnnotation.getLength();
        if (charPos > this.textLength) {
            log.error("Annotation of type " + anAnnotation.getType().toString() + " out of range, charPos > textSize");
            return false;
        }
        if (charPos + length > this.textLength) {
            log.error("Annotation of type " + anAnnotation.getType().toString() + " out of range, charPos + length > textSize");
            return false;
        }
        return true;
    }

    private boolean insideTitle(TextAnnotation anAnnotation) {
        if (this.titleLength <= 0) {
            return false;
        }
        return anAnnotation.getCharPos() < this.titleLength - 1;
    }

    private void adjustCharPosToTitleLength(TextAnnotation annotation) {
        int charPos;
        if (annotation == null) {
            return;
        }
        if (this.titleLength <= 0 && !BuiltInEntityTypes.TOPONYM.equals((Object)annotation.getType())) {
            return;
        }
        int adjustedCharPos = charPos = annotation.getCharPos();
        adjustedCharPos = charPos < this.titleLength - 1 ? 0 : (BuiltInEntityTypes.TOPONYM.equals((Object)annotation.getType()) && this.titleLength == 0 ? charPos - TITLE_TEXT_SEPARATOR.length() : charPos - this.titleLength);
        annotation.setCharPos(adjustedCharPos);
    }

    public void remove(TextAnnotation anAnnotation) {
        Set annotations = (Set)this.annotationMap.get(anAnnotation.getCharPos());
        if (annotations.isEmpty()) {
            return;
        }
        annotations.remove(anAnnotation);
    }

    public Set<TextAnnotation> getAll() {
        TreeSet<TextAnnotation> resultSet = new TreeSet<TextAnnotation>(new AnnotationComparator());
        for (Set annotations : this.annotationMap.values()) {
            resultSet.addAll(annotations);
        }
        return resultSet;
    }

    public static String dump(TextAnnotationModel aModel, String text) {
        StringBuffer strBuf = new StringBuffer();
        Set<TextAnnotation> annotations = aModel.getAll();
        if (annotations.isEmpty()) {
            strBuf.append("\n");
        }
        for (TextAnnotation anAnnotation : annotations) {
            strBuf.append(anAnnotation.toString());
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    private static class AnnotationComparator
    implements Comparator<TextAnnotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(TextAnnotation ann1, TextAnnotation ann2) {
            if (ann1.getCharPos() < ann2.getCharPos()) {
                return -1;
            }
            if (ann1.getCharPos() > ann2.getCharPos()) {
                return 1;
            }
            if (ann1.getLength() < ann2.getLength()) {
                return 1;
            }
            if (ann1.getLength() > ann2.getLength()) {
                return -1;
            }
            return 0;
        }
    }

    public static interface TextAnnotationFilter {
        public boolean filterOut(TextAnnotation var1);
    }
}

