/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.extract.ui.dialog.ComboViewers;
import it.jrc.osint.extract.ui.dialog.EditProfileController;
import it.jrc.osint.extract.ui.dialog.VariantTableViewerHelper;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class EditProfileDialog
extends Dialog {
    private DataBindingContext m_bindingContext;
    private EditProfileController controller;
    private Label profileNameLabel;
    private ComboViewer typeComboViewer;
    private Button variantAddButton;
    private Button variantDeleteButton;
    private Button changeProfileNameButton;
    private Button variantLanguageButton;
    private TableViewer variantTableViewer;
    private Table variantTable;

    public EditProfileDialog(Shell parentShell, EditProfileController controller) {
        super(parentShell);
        this.setShellStyle(48);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginBottom = 5;
        gl_container.marginTop = 5;
        gl_container.marginLeft = 5;
        container.setLayout((Layout)gl_container);
        Composite profileContainer = new Composite(container, 0);
        profileContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        profileContainer.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(profileContainer, 0);
        nameLabel.setSize(72, 15);
        nameLabel.setText("Profile Name:");
        this.profileNameLabel = new Label(profileContainer, 0);
        this.profileNameLabel.setToolTipText("The profile name is taken from the canonical name variants (first in list)");
        this.profileNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.profileNameLabel.setText("-Profile Name-");
        Label typeLabel = new Label(profileContainer, 0);
        typeLabel.setText("Profile Type:");
        Combo typeCombo = new Combo(profileContainer, 8);
        typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.typeComboViewer = ComboViewers.createEntityTypeComboViewer(typeCombo);
        this.typeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    EditProfileDialog.this.controller.changeEntityTypeOfProfile((EntityType)selection.getFirstElement());
                }
            }
        });
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setText("Name Variants:");
        Composite variantsContainerComposite = new Composite(container, 0);
        variantsContainerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_variantsContainerComposite = new GridLayout(2, false);
        gl_variantsContainerComposite.verticalSpacing = 0;
        gl_variantsContainerComposite.marginWidth = 0;
        gl_variantsContainerComposite.marginHeight = 0;
        variantsContainerComposite.setLayout((Layout)gl_variantsContainerComposite);
        Composite variantsTableContainer = new Composite(variantsContainerComposite, 0);
        GridData gd_variantsTableContainer = new GridData(4, 4, true, true, 1, 1);
        gd_variantsTableContainer.widthHint = 438;
        gd_variantsTableContainer.verticalIndent = 5;
        variantsTableContainer.setLayoutData((Object)gd_variantsTableContainer);
        TableColumnLayout tcl_variantsTableContainer = new TableColumnLayout();
        variantsTableContainer.setLayout((Layout)tcl_variantsTableContainer);
        this.variantTable = new Table(variantsTableContainer, 0x10010800);
        this.variantTable.setLinesVisible(true);
        this.variantTable.setHeaderVisible(true);
        this.variantTableViewer = VariantTableViewerHelper.createVariantTableViewer(this.variantTable);
        TableColumn tableColumnName = new TableColumn(this.variantTable, 0);
        tableColumnName.setToolTipText("Variant Name");
        tableColumnName.setText("Name");
        TableViewerColumn tvColumnName = VariantTableViewerHelper.createVariantTableViewerColumn(this.variantTableViewer, tableColumnName);
        ColumnWeightData cwd_tableColumnName = new ColumnWeightData(60);
        cwd_tableColumnName.minimumWidth = 150;
        tcl_variantsTableContainer.setColumnData((Widget)tableColumnName, (ColumnLayoutData)cwd_tableColumnName);
        tvColumnName.setEditingSupport((EditingSupport)new VariantTableViewerHelper.EditingSupportNameColumn(this.variantTableViewer, this.controller));
        TableColumn tableColumnIgnore = new TableColumn(this.variantTable, 0);
        tableColumnIgnore.setToolTipText("Variant name is ignored by entity extraction");
        tableColumnIgnore.setText("Ignored");
        TableViewerColumn tvColumnIgnore = VariantTableViewerHelper.createVariantTableViewerColumn(this.variantTableViewer, tableColumnIgnore);
        tcl_variantsTableContainer.setColumnData((Widget)tableColumnIgnore, (ColumnLayoutData)new ColumnWeightData(20));
        tvColumnIgnore.setEditingSupport((EditingSupport)new VariantTableViewerHelper.EditingSupportIgnoreColumn(this.variantTableViewer, this.controller));
        Composite variantsButtonComposite = new Composite(variantsContainerComposite, 0);
        GridData gd_variantsButtonComposite = new GridData(4, 4, true, true, 1, 1);
        gd_variantsButtonComposite.widthHint = 75;
        variantsButtonComposite.setLayoutData((Object)gd_variantsButtonComposite);
        variantsButtonComposite.setBounds(0, 0, 64, 64);
        variantsButtonComposite.setLayout((Layout)new GridLayout(1, false));
        this.changeProfileNameButton = new Button(variantsButtonComposite, 0);
        this.changeProfileNameButton.setToolTipText("Set the selected name variants as canonical to name the profile");
        this.changeProfileNameButton.setText("Change Profile Name");
        this.changeProfileNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.controller.changeCanonicalVariantOfProfile();
            }
        });
        new Label(variantsButtonComposite, 0);
        this.variantAddButton = new Button(variantsButtonComposite, 0);
        this.variantAddButton.setToolTipText("Create a new name variant for this profile");
        this.variantAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.controller.addNewNameVariant();
            }
        });
        GridData gd_aliasAddButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_aliasAddButton.widthHint = 65;
        this.variantAddButton.setLayoutData((Object)gd_aliasAddButton);
        this.variantAddButton.setBounds(0, 0, 75, 25);
        this.variantAddButton.setText("Add Variant");
        this.variantDeleteButton = new Button(variantsButtonComposite, 0);
        this.variantDeleteButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.variantDeleteButton.setText("Delete Variant");
        this.variantDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditProfileDialog.this.controller.deleteNameVariant();
            }
        });
        this.variantLanguageButton = new Button(variantsButtonComposite, 0);
        this.variantLanguageButton.setToolTipText("Change language settings for variant");
        this.variantLanguageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gd_variantLanguageButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_variantLanguageButton.widthHint = 65;
        this.variantLanguageButton.setLayoutData((Object)gd_variantLanguageButton);
        this.variantLanguageButton.setBounds(0, 0, 75, 25);
        this.variantLanguageButton.setText("Language Settings...");
        this.variantLanguageButton.setVisible(false);
        this.variantTableViewer.setUseHashlookup(true);
        this.variantTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    EditProfileDialog.this.controller.deselectNameVariant();
                } else {
                    Object selectedElement = selection.getFirstElement();
                    if (selectedElement instanceof NameVariant) {
                        EditProfileDialog.this.controller.selectNameVariant((NameVariant)selectedElement);
                    }
                }
            }
        });
        this.initContent();
        return container;
    }

    private void initContent() {
        this.controller.onViewCreation();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_bindingContext = this.initDataBindings();
    }

    protected Point getInitialSize() {
        return new Point(681, 549);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Entity Name Profile");
    }

    ComboViewer getEntityTypeComboViewer() {
        return this.typeComboViewer;
    }

    private Button getChangeProfileButton() {
        return this.changeProfileNameButton;
    }

    void enableChangeProfileButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getChangeProfileButton().setEnabled(true);
            }
        });
    }

    void disableChangeProfileButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getChangeProfileButton().setEnabled(false);
            }
        });
    }

    private Button getAddButton() {
        return this.variantAddButton;
    }

    void enableAddButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getAddButton().setEnabled(true);
            }
        });
    }

    void disableAddButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getAddButton().setEnabled(false);
            }
        });
    }

    private Button getIgnoreButton() {
        return this.variantLanguageButton;
    }

    void setIgnoreButtonLabel(final String newLabel) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getIgnoreButton().setText(newLabel);
            }
        });
    }

    void enableIgnoreButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getIgnoreButton().setEnabled(true);
            }
        });
    }

    void disableIgnoreButton() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.getIgnoreButton().setEnabled(false);
            }
        });
    }

    void setProfileName(final String profileName) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.profileNameLabel.setText(profileName);
            }
        });
    }

    TableViewer getNameVariantTableViewer() {
        return this.variantTableViewer;
    }

    void refreshNameVariantTableViewer() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                EditProfileDialog.this.variantTableViewer.refresh();
            }
        });
    }

    void showWarningDialog(String message) {
        MessageDialog.openWarning((Shell)this.getParentShell(), (String)"Warning", (String)message);
    }

    void showInfoDialog(String message) {
        MessageDialog.openInformation((Shell)this.getParentShell(), (String)"Info", (String)message);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

