/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ListViewers {
    public static ListViewer createEntityListViewer(org.eclipse.swt.widgets.List aList) {
        ListViewer entityListViewer = new ListViewer(aList);
        entityListViewer.setContentProvider((IContentProvider)new EntitiesListViewerContentProvider());
        entityListViewer.setLabelProvider((IBaseLabelProvider)new EntitiesListViewerLabelProvider());
        return entityListViewer;
    }

    public static void filterAllButSingleEntityType(ListViewer entityListViewer, EntityType entityType) {
        if (EntityType.NULL_TYPE.equals((Object)entityType)) {
            entityListViewer.setFilters(new ViewerFilter[0]);
        }
        entityListViewer.setFilters(new ViewerFilter[]{new EntityTypeFilter(entityType)});
    }

    private static class EntitiesListViewerContentProvider
    extends StructuredContentProviderAdapter {
        private EntitiesListViewerContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof String) {
                return new String[]{(String)input};
            }
            if (input instanceof List) {
                List entities = (List)input;
                return entities.toArray();
            }
            return new Object[0];
        }
    }

    private static class EntitiesListViewerLabelProvider
    extends LabelProviderAdapter {
        private EntitiesListViewerLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Entity) {
                Entity e = (Entity)obj;
                return e.getName();
            }
            return null;
        }
    }

    private static class EntityTypeFilter
    extends ViewerFilter {
        private EntityType entityType;

        public EntityTypeFilter(EntityType typeToShow) {
            this.entityType = typeToShow;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof String) {
                return true;
            }
            if (element instanceof Entity) {
                Entity anEntity = (Entity)element;
                return anEntity.getType().equals(this.entityType.getId());
            }
            return false;
        }
    }
}

