/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.extract.ui.dialog.ComboViewers;
import it.jrc.osint.extract.ui.dialog.EntityTypeFilter;
import it.jrc.osint.extract.ui.dialog.SearchProfileController;
import it.jrc.osint.extract.ui.dialog.VariantTableViewerHelper;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SearchProfileDialog
extends Dialog {
    private DataBindingContext m_bindingContext;
    private SearchProfileController controller;
    private String titleText;
    private Text text;
    private ComboViewer filterTypeComboViewer;
    private Button editButton;
    private Button newButton;
    private Button deleteButton;
    private Table variantsTable;
    private TableViewer variantsTableViewer;
    private Table profileTable;
    private TableViewer profileTableViewer;
    private EntityTypeFilter tableTypeFilter;
    private Button searchButton;

    public SearchProfileDialog(Shell parentShell, SearchProfileController controller) {
        super(parentShell);
        this.setShellStyle(48);
        this.controller = controller;
        this.titleText = "Edit Name Variant Database";
    }

    public void setTitleText(String newTitle) {
        this.titleText = newTitle;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(container, 0);
        searchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        searchComposite.setLayout((Layout)new GridLayout(3, false));
        Label lblNameanyString = new Label(searchComposite, 0);
        GridData gd_lblNameanyString = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNameanyString.horizontalIndent = 3;
        lblNameanyString.setLayoutData((Object)gd_lblNameanyString);
        lblNameanyString.setText("Name (*=any string, ?=any character):");
        this.text = new Text(searchComposite, 2176);
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!SearchProfileDialog.this.getSearchButton().isDisposed()) {
                    SearchProfileDialog.this.disableOkButton();
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && SearchProfileDialog.this.getSearchButton().isEnabled()) {
                    SearchProfileDialog.this.controller.performSearch();
                }
            }
        });
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.searchButton = new Button(searchComposite, 0);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchProfileDialog.this.controller.performSearch();
            }
        });
        GridData gd_searchButton = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_searchButton.widthHint = 60;
        this.searchButton.setLayoutData((Object)gd_searchButton);
        this.searchButton.setText("Search");
        Composite filterComposite = new Composite(container, 0);
        filterComposite.setLayout((Layout)new GridLayout(2, false));
        filterComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_1 = new Label(filterComposite, 0);
        GridData gd_lblNewLabel_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_1.horizontalIndent = 3;
        lblNewLabel_1.setLayoutData((Object)gd_lblNewLabel_1);
        lblNewLabel_1.setText("Filter:");
        Combo filterTypeCombo = new Combo(filterComposite, 8);
        GridData gd_filterTypeCombo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_filterTypeCombo.minimumWidth = 100;
        filterTypeCombo.setLayoutData((Object)gd_filterTypeCombo);
        this.filterTypeComboViewer = ComboViewers.createEntityTypeComboViewer(filterTypeCombo);
        this.filterTypeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                EntityType type = (EntityType)sel.getFirstElement();
                SearchProfileDialog.this.controller.setFilterEntityType(type);
            }
        });
        this.filterTypeComboViewer.setInput(this.controller.getEntityTypes());
        Composite resultComposite = new Composite(container, 0);
        GridData gd_resultComposite = new GridData(4, 4, false, true, 1, 1);
        gd_resultComposite.widthHint = 658;
        resultComposite.setLayoutData((Object)gd_resultComposite);
        resultComposite.setLayout((Layout)new GridLayout(3, false));
        SashForm resultSashForm = new SashForm(resultComposite, 256);
        resultSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        resultSashForm.setLayout((Layout)new FillLayout());
        Composite resultNameVariantComposite = new Composite((Composite)resultSashForm, 0);
        resultNameVariantComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblNameVariants = new Label(resultNameVariantComposite, 0);
        lblNameVariants.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblNameVariants.setText("Matching Name Variants:");
        Composite tableContainer = new Composite(resultNameVariantComposite, 0);
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableColumnLayout);
        this.variantsTable = new Table(tableContainer, 0x10010800);
        this.variantsTable.setLinesVisible(true);
        this.variantsTable.setHeaderVisible(true);
        this.variantsTableViewer = VariantTableViewerHelper.createVariantTableViewer(this.variantsTable);
        TableColumn tableColumnName = new TableColumn(this.variantsTable, 0);
        tableColumnName.setToolTipText("Variant Name");
        tableColumnName.setText("Name");
        VariantTableViewerHelper.createVariantTableViewerColumn(this.variantsTableViewer, tableColumnName);
        tableColumnLayout.setColumnData((Widget)tableColumnName, (ColumnLayoutData)new ColumnWeightData(75));
        TableColumn tableColumnType = new TableColumn(this.variantsTable, 0);
        tableColumnType.setToolTipText("Type");
        tableColumnType.setText("Type");
        VariantTableViewerHelper.createVariantTableViewerColumn(this.variantsTableViewer, tableColumnType);
        tableColumnLayout.setColumnData((Widget)tableColumnType, (ColumnLayoutData)new ColumnWeightData(25));
        this.variantsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    SearchProfileDialog.this.controller.deselectNameVariant();
                } else {
                    Object selectedElement = selection.getFirstElement();
                    if (selectedElement instanceof NameVariant) {
                        SearchProfileDialog.this.controller.selectNameVariant((NameVariant)selectedElement);
                    }
                }
            }
        });
        Composite resultEntityProfileComposite = new Composite((Composite)resultSashForm, 0);
        resultEntityProfileComposite.setLayout((Layout)new GridLayout(1, false));
        Label lblProfiles = new Label(resultEntityProfileComposite, 0);
        lblProfiles.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblProfiles.setText("Name Variant Profile:");
        Composite profileTableContainer = new Composite(resultEntityProfileComposite, 0);
        profileTableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_profileTableContainer = new TableColumnLayout();
        profileTableContainer.setLayout((Layout)tcl_profileTableContainer);
        this.profileTable = new Table(profileTableContainer, 0x10010800);
        this.profileTable.setLinesVisible(true);
        this.profileTable.setHeaderVisible(true);
        this.profileTableViewer = VariantTableViewerHelper.createNameVariantProfileTableViewer(this.profileTable);
        TableColumn profileTableColumnName = new TableColumn(this.profileTable, 0);
        profileTableColumnName.setToolTipText("Name Variant");
        profileTableColumnName.setText("Name");
        VariantTableViewerHelper.createVariantTableViewerColumn(this.profileTableViewer, profileTableColumnName);
        tcl_profileTableContainer.setColumnData((Widget)profileTableColumnName, (ColumnLayoutData)new ColumnWeightData(80));
        resultSashForm.setWeights(new int[]{292, 304});
        TableColumn profileTableColumnIgnore = new TableColumn(this.profileTable, 0);
        profileTableColumnIgnore.setToolTipText("Variant name is ignored by entity extraction");
        profileTableColumnIgnore.setText("Ignored");
        VariantTableViewerHelper.createVariantTableViewerColumn(this.profileTableViewer, profileTableColumnIgnore);
        tcl_profileTableContainer.setColumnData((Widget)profileTableColumnIgnore, (ColumnLayoutData)new ColumnWeightData(20));
        Composite resultProfileEditingComposite = new Composite(resultComposite, 0);
        resultProfileEditingComposite.setLayout((Layout)new RowLayout(512));
        resultProfileEditingComposite.setLayoutData((Object)new GridData(131072, 4, false, true, 1, 1));
        this.editButton = new Button(resultProfileEditingComposite, 0);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchProfileDialog.this.controller.openEditExistingProfileDialog();
            }
        });
        this.editButton.setLayoutData((Object)new RowData(60, -1));
        this.editButton.setText("Edit...");
        this.newButton = new Button(resultProfileEditingComposite, 0);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchProfileDialog.this.controller.openEditNewProfileDialog();
            }
        });
        this.newButton.setLayoutData((Object)new RowData(60, -1));
        this.newButton.setText("New...");
        this.deleteButton = new Button(resultProfileEditingComposite, 0);
        this.deleteButton.setLayoutData((Object)new RowData(60, -1));
        this.deleteButton.setText("Delete...");
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchProfileDialog.this.controller.deleteProfile();
            }
        });
        this.initContent();
        return container;
    }

    boolean showConfirmationDialog(String message) {
        return MessageDialog.openConfirm((Shell)this.getParentShell(), (String)"Please Confirm", (String)message);
    }

    private void initContent() {
        this.controller.onViewCreation();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.titleText);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.m_bindingContext = this.initDataBindings();
    }

    protected Point getInitialSize() {
        return new Point(706, 510);
    }

    void setVariantsTableInput(final Object newInput) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchProfileDialog.this.variantsTableViewer.setInput(newInput);
            }
        });
    }

    void setNameVariantProfileTableInput(final Object newInput) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchProfileDialog.this.profileTableViewer.setInput(newInput);
            }
        });
    }

    void hideEditButton() {
        this.editButton.setVisible(false);
    }

    void hideNewButton() {
        this.newButton.setVisible(false);
    }

    void enableDeleteButton() {
        this.setButtonEnabled(this.getDeleteButton(), true);
    }

    void disableDeleteButton() {
        this.setButtonEnabled(this.getDeleteButton(), false);
    }

    private Button getDeleteButton() {
        return this.deleteButton;
    }

    void enableEditButton() {
        this.setButtonEnabled(this.getEditButton(), true);
    }

    void disableEditButton() {
        this.setButtonEnabled(this.getEditButton(), false);
    }

    private Button getEditButton() {
        return this.editButton;
    }

    void enableOkButton() {
        this.setButtonEnabled(this.getOkButton(), true);
    }

    void disableOkButton() {
        this.setButtonEnabled(this.getOkButton(), false);
    }

    Button getOkButton() {
        return this.getButton(0);
    }

    void enableSearchButton() {
        this.setButtonEnabled(this.getSearchButton(), true);
    }

    void disableSearchButton() {
        this.setButtonEnabled(this.getSearchButton(), false);
    }

    private void setButtonEnabled(final Button aButton, final boolean enabled) {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (aButton != null && !aButton.isDisposed()) {
                    aButton.setEnabled(enabled);
                }
            }
        });
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue textObserveTextObserveWidget = SWTObservables.observeText((Control)this.text, (int)24);
        IObservableValue controllerSearchPatternObserveValue = PojoObservables.observeValue((Object)this.controller, (String)"searchPattern");
        bindingContext.bindValue((IObservableValue)textObserveTextObserveWidget, controllerSearchPatternObserveValue, null, null);
        IViewerObservableValue filterTypeComboViewerObserveSingleSelection = ViewersObservables.observeSingleSelection((Viewer)this.filterTypeComboViewer);
        IObservableValue controllerSelectedEntityTypeObserveValue = PojoObservables.observeValue((Object)this.controller, (String)"filterEntityType");
        bindingContext.bindValue((IObservableValue)filterTypeComboViewerObserveSingleSelection, controllerSelectedEntityTypeObserveValue, null, null);
        return bindingContext;
    }

    public void setEntityTypeFilter(EntityType entityType) {
        this.filterTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)entityType));
    }

    public void applyEntityTypeFilter(EntityType entityType) {
        if (entityType == null) {
            return;
        }
        if (entityType.equals((Object)EntityType.NULL_TYPE)) {
            if (this.tableTypeFilter != null) {
                Display dsp = this.getShell().getDisplay();
                dsp.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchProfileDialog.this.variantsTableViewer.removeFilter((ViewerFilter)SearchProfileDialog.this.tableTypeFilter);
                    }
                });
            }
            return;
        }
        this.tableTypeFilter = new EntityTypeFilter(entityType);
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchProfileDialog.this.variantsTableViewer.setFilters(new ViewerFilter[]{SearchProfileDialog.this.tableTypeFilter});
            }
        });
    }

    public void showEmptyResultDialog() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)SearchProfileDialog.this.getShell(), (String)"Search for Entities", (String)"No results found");
            }
        });
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    void refreshVariantsTableViewer() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchProfileDialog.this.variantsTableViewer.refresh();
            }
        });
    }

    void refreshProfileTableViewer() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchProfileDialog.this.profileTableViewer.refresh();
            }
        });
    }
}

