/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.extract.ui.dialog;

import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.NameVariant;
import it.jrc.osint.extract.NameVariantProfile;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.extract.ui.ExtractUIPlugin;
import it.jrc.osint.extract.ui.dialog.EditProfileController;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class VariantTableViewerHelper {
    public static final String NAME_COLUMN = "Name";
    public static final String TYPE_COLUMN = "Type";
    public static final String LANGUAGE_COLUMN = "Language";
    public static final String IGNORE_COLUMN = "Ignored";

    public static TableViewer createVariantTableViewer(Table aTable) {
        TableViewer entityTableViewer = new TableViewer(aTable);
        entityTableViewer.setContentProvider((IContentProvider)new VariantListContentProvider());
        entityTableViewer.setLabelProvider((IBaseLabelProvider)new VariantLabelProvider());
        entityTableViewer.setComparator((ViewerComparator)new VariantViewerComparator());
        return entityTableViewer;
    }

    public static TableViewer createNameVariantProfileTableViewer(Table aTable) {
        TableViewer aliasTableViewer = new TableViewer(aTable);
        aliasTableViewer.setContentProvider((IContentProvider)new NameVariantProfileContentProvider());
        aliasTableViewer.setLabelProvider((IBaseLabelProvider)new VariantLabelProvider());
        aliasTableViewer.setComparator((ViewerComparator)new VariantViewerComparator());
        return aliasTableViewer;
    }

    public static TableViewerColumn createVariantTableViewerColumn(TableViewer tableViewer, TableColumn column) {
        TableViewerColumn tvColumn = new TableViewerColumn(tableViewer, column);
        ColumnViewerSorter cSorter = null;
        if (column.getText().equals(NAME_COLUMN)) {
            cSorter = new ColumnViewerSorter((ColumnViewer)tableViewer, tvColumn){

                @Override
                protected int doCompare(Viewer viewer, Object o1, Object o2) {
                    NameVariant nv1 = (NameVariant)o1;
                    NameVariant nv2 = (NameVariant)o2;
                    return nv1.getName().compareToIgnoreCase(nv2.getName());
                }
            };
            tvColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    if (element instanceof NameVariant) {
                        return ((NameVariant)element).getName();
                    }
                    return "";
                }
            });
            cSorter.setSorter(cSorter, 1);
        }
        if (column.getText().equals(TYPE_COLUMN)) {
            cSorter = new ColumnViewerSorter((ColumnViewer)tableViewer, tvColumn){

                @Override
                protected int doCompare(Viewer viewer, Object o1, Object o2) {
                    NameVariant nv1 = (NameVariant)o1;
                    NameVariant nv2 = (NameVariant)o2;
                    return nv1.getType().compareToIgnoreCase(nv2.getType());
                }
            };
            tvColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return "";
                    }
                    if (element instanceof NameVariant) {
                        return ((NameVariant)element).getType();
                    }
                    return "";
                }
            });
        }
        if (column.getText().equals(IGNORE_COLUMN)) {
            cSorter = new ColumnViewerSorter((ColumnViewer)tableViewer, tvColumn){

                @Override
                protected int doCompare(Viewer viewer, Object o1, Object o2) {
                    NameVariant nv1 = (NameVariant)o1;
                    NameVariant nv2 = (NameVariant)o2;
                    if (nv1.isValid()) {
                        if (nv2.isValid()) {
                            return 0;
                        }
                        if (!nv2.isValid()) {
                            return 1;
                        }
                    } else {
                        if (nv2.isValid()) {
                            return -1;
                        }
                        if (!nv2.isValid()) {
                            return 0;
                        }
                    }
                    return 0;
                }
            };
            tvColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof NameVariant) {
                        NameVariant nv = (NameVariant)element;
                        if (!nv.isValid()) {
                            return "ignored";
                        }
                        return "";
                    }
                    return element.toString();
                }
            });
        }
        if (column.getText().equals(LANGUAGE_COLUMN)) {
            cSorter = new ColumnViewerSorter((ColumnViewer)tableViewer, tvColumn){

                @Override
                protected int doCompare(Viewer viewer, Object o1, Object o2) {
                    NameVariant nv1 = (NameVariant)o1;
                    NameVariant nv2 = (NameVariant)o2;
                    return nv1.getLanguages().compareToIgnoreCase(nv2.getLanguages());
                }
            };
            tvColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        return "";
                    }
                    if (element instanceof NameVariant) {
                        NameVariant nv = (NameVariant)element;
                        return nv.getLanguages();
                    }
                    return "";
                }
            });
        }
        return tvColumn;
    }

    private static abstract class ColumnViewerSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int NONE = 0;
        public static final int DESC = -1;
        private int direction = 0;
        private TableViewerColumn column;
        private ColumnViewer viewer;

        public ColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
            this.column = column;
            this.viewer = viewer;
            this.column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (viewer.getComparator() != null) {
                        if (viewer.getComparator() == this) {
                            int tdirection = direction;
                            if (tdirection == 1) {
                                this.setSorter(this, -1);
                            } else if (tdirection == -1) {
                                this.setSorter(this, 0);
                            }
                        } else {
                            this.setSorter(this, 1);
                        }
                    } else {
                        this.setSorter(this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnViewerSorter sorter, int direction) {
            if (direction == 0) {
                this.column.getColumn().getParent().setSortColumn(null);
                this.column.getColumn().getParent().setSortDirection(0);
                this.viewer.setComparator(null);
            } else {
                this.column.getColumn().getParent().setSortColumn(this.column.getColumn());
                sorter.direction = direction;
                if (direction == 1) {
                    this.column.getColumn().getParent().setSortDirection(1024);
                } else {
                    this.column.getColumn().getParent().setSortDirection(128);
                }
                if (this.viewer.getComparator() == sorter) {
                    this.viewer.refresh();
                } else {
                    this.viewer.setComparator((ViewerComparator)sorter);
                }
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.direction * this.doCompare(viewer, e1, e2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }

    public static class EditingSupportIgnoreColumn
    extends EditingSupport {
        private final EditProfileController controller;

        public EditingSupportIgnoreColumn(TableViewer tableViewer, EditProfileController controller) {
            super((ColumnViewer)tableViewer);
            this.controller = controller;
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor(null, 32);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((NameVariant)element).isValid();
        }

        protected void setValue(Object element, Object value) {
            this.controller.changeValidStateOfVariant((NameVariant)element, (Boolean)value);
        }
    }

    public static class EditingSupportNameColumn
    extends EditingSupport {
        private final TableViewer tableViewer;
        private final EditProfileController controller;

        public EditingSupportNameColumn(TableViewer tableViewer, EditProfileController controller) {
            super((ColumnViewer)tableViewer);
            this.tableViewer = tableViewer;
            this.controller = controller;
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor cellEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
            return cellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((NameVariant)element).getName();
        }

        protected void setValue(Object element, Object value) {
            this.controller.changeNameOfVariant((NameVariant)element, (String)value);
        }
    }

    private static class NameVariantProfileContentProvider
    extends StructuredContentProviderAdapter {
        private NameVariantProfileContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof String) {
                return new String[]{(String)input};
            }
            if (input instanceof NameVariantProfile) {
                NameVariantProfile nvp = (NameVariantProfile)input;
                List variants = nvp.getNameVariants();
                return variants.toArray();
            }
            return new Object[0];
        }
    }

    private static class VariantLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private VariantLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        return (String)element;
                    }
                    case 1: {
                        return "";
                    }
                }
                return "unknown idx " + columnIndex;
            }
            if (element instanceof NameVariant) {
                NameVariant nameVariant = (NameVariant)element;
                switch (columnIndex) {
                    case 0: {
                        return nameVariant.getName();
                    }
                    case 1: {
                        return this.getEntityTypeName(nameVariant.getType());
                    }
                }
                return "unknown idx " + columnIndex;
            }
            return "null";
        }

        private String getEntityTypeName(String id) {
            ExtractionService es = ExtractUIPlugin.getExtractionService();
            EntityType type = es.getEntityType(id);
            return type.getName();
        }
    }

    private static class VariantListContentProvider
    extends StructuredContentProviderAdapter {
        private VariantListContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof String) {
                return new String[]{(String)input};
            }
            if (input instanceof List) {
                List variants = (List)input;
                return variants.toArray();
            }
            return new Object[0];
        }
    }

    private static class VariantViewerComparator
    extends ViewerComparator {
        private VariantViewerComparator() {
        }

        public int compare(Viewer viewer, Object element1, Object element2) {
            if (element1 instanceof String && element2 instanceof String) {
                String str1 = (String)element1;
                String str2 = (String)element2;
                return str1.compareTo(str2);
            }
            if (element1 instanceof NameVariant && element2 instanceof NameVariant) {
                String name1 = ((NameVariant)element1).getName();
                String name2 = ((NameVariant)element2).getName();
                return name1.compareTo(name2);
            }
            return super.compare(viewer, element1, element2);
        }
    }
}

