/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.cmatcher.generator;

import com.google.common.base.Objects;
import it.jrc.osint.cmatcher.alertDSL.Alert;
import it.jrc.osint.cmatcher.alertDSL.CombinationSection;
import it.jrc.osint.cmatcher.alertDSL.CombinationType;
import it.jrc.osint.cmatcher.alertDSL.Model;
import it.jrc.osint.cmatcher.alertDSL.NotType;
import it.jrc.osint.cmatcher.alertDSL.OrType;
import it.jrc.osint.cmatcher.alertDSL.PatternSection;
import it.jrc.osint.cmatcher.alertDSL.PatternWeightType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AlertDSLGenerator
implements IGenerator {
    private final int DEFAULT_THRESHOLD = 25;
    private final int DEFAULT_PROXIMITY = 10;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        EList _contents = resource.getContents();
        EObject headObject = (EObject)IterableExtensions.head((Iterable)_contents);
        if (headObject instanceof Model) {
            EList<Alert> alerts = ((Model)headObject).getAlerts();
            boolean _isEmpty = alerts.isEmpty();
            if (_isEmpty) {
                InputOutput.println((Object)"Alerts list of model is empty: no Alert object found");
            } else {
                Alert _head;
                Alert alert = _head = (Alert)IterableExtensions.head(alerts);
                String _id = alert.getId();
                String _plus = String.valueOf(_id) + ".xml";
                CharSequence _compile = this.compile(alert);
                fsa.generateFile(_plus, _compile);
            }
        } else {
            InputOutput.println((Object)"No Alert object found");
        }
    }

    public CharSequence compile(Alert a) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        _builder.newLine();
        _builder.append("<alertInfo xsi:noNamespaceSchemaLocation=\"http://emm.jrc.org/alert.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        _builder.newLine();
        _builder.append("<alerts>");
        _builder.newLine();
        _builder.append("<alert id=\"");
        String _id = a.getId();
        _builder.append(_id, "");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("<definition>");
        _builder.newLine();
        PatternSection _patternSection = a.getPatternSection();
        boolean bl = _notEquals = !Objects.equal((Object)_patternSection, null);
        if (_notEquals) {
            PatternSection _patternSection_1 = a.getPatternSection();
            CharSequence _compile = this.compile(_patternSection_1);
            _builder.append((Object)_compile, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("<mustContain>");
        _builder.newLine();
        EList<CombinationSection> _combinationSection = a.getCombinationSection();
        for (CombinationSection c : _combinationSection) {
            CombinationType _combination = c.getCombination();
            CharSequence _compile_1 = this.compile(_combination);
            _builder.append((Object)_compile_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</mustContain>");
        _builder.newLine();
        _builder.append("</definition>");
        _builder.newLine();
        _builder.append("</alert>");
        _builder.newLine();
        _builder.append("</alerts>");
        _builder.newLine();
        _builder.append("</alertInfo>\t\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(PatternSection ps) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<words threshold=\"");
        int _threshold = ps.getThreshold();
        boolean bl = _equals = _threshold == 0;
        if (_equals) {
            _builder.append((Object)25, "");
        } else {
            int _threshold_1 = ps.getThreshold();
            _builder.append((Object)_threshold_1, "");
        }
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList<PatternWeightType> _patterns = ps.getPatterns();
        for (PatternWeightType p : _patterns) {
            _builder.append("\t");
            CharSequence _compile = this.compile(p);
            _builder.append((Object)_compile, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</words>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(PatternWeightType pwt) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<word>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<pattern>");
        String _pattern = pwt.getPattern();
        _builder.append(_pattern, "\t");
        _builder.append("</pattern>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<weight>");
        String _weight = pwt.getWeight();
        _builder.append(_weight, "\t");
        _builder.append("</weight>");
        _builder.newLineIfNotEmpty();
        _builder.append("</word>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(CombinationType ct) {
        boolean _notEquals;
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<combination proximity=\"");
        int _proximity = ct.getProximity();
        boolean bl = _equals = _proximity == 0;
        if (_equals) {
            _builder.append((Object)10, "");
        } else {
            int _proximity_1 = ct.getProximity();
            _builder.append((Object)_proximity_1, "");
        }
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        EList<OrType> _ors = ct.getOrs();
        for (OrType or : _ors) {
            CharSequence _compile = this.compile(or);
            _builder.append((Object)_compile, "");
            _builder.newLineIfNotEmpty();
        }
        NotType _not = ct.getNot();
        boolean bl2 = _notEquals = !Objects.equal((Object)_not, null);
        if (_notEquals) {
            _builder.append("<not>");
            _builder.newLine();
            NotType _not_1 = ct.getNot();
            EList<String> _patterns = _not_1.getPatterns();
            for (String ntp : _patterns) {
                _builder.append("<pattern>");
                _builder.append(ntp, "");
                _builder.append("</pattern>");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("</not>");
            _builder.newLine();
        }
        _builder.append("</combination>\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compile(OrType ot) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<or>");
        _builder.newLine();
        EList<String> _patterns = ot.getPatterns();
        for (String otp : _patterns) {
            _builder.append("<pattern>");
            _builder.append(otp, "");
            _builder.append("</pattern>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</or>");
        _builder.newLine();
        return _builder;
    }
}

