/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.navigator;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ResourceExtensionContentProvider
extends WorkbenchContentProvider {
    private static final Logger log = LogManager.getLogger((String)ResourceExtensionContentProvider.class.getName());
    private static final Object[] NO_CHILDREN = new Object[0];
    private Viewer viewer;

    public Object[] getElements(Object element) {
        return super.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IFile) {
            return NO_CHILDREN;
        }
        if (element instanceof IResource) {
            return super.getChildren(element);
        }
        return NO_CHILDREN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IContainer) {
                IContainer c = (IContainer)element;
                if (c.isAccessible()) return c.members().length > 0;
                return false;
            }
            if (!(element instanceof IFile)) return super.hasChildren(element);
            return false;
        }
        catch (CoreException ex) {
            log.error("hasChildren failed", (Throwable)ex);
            return false;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final ArrayList runnables = new ArrayList();
        this.processDelta(delta, runnables);
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Control ctrl = ResourceExtensionContentProvider.this.viewer.getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    ResourceExtensionContentProvider.this.runUpdates(runnables);
                }
            });
        }
    }

    private void processDelta(IResourceDelta delta, Collection runnables) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x9C000) != 0) {
            runnables.add(this.getRefreshRunnable((IResource)resource.getParent()));
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3], runnables);
            ++i3;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        final boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (ResourceExtensionContentProvider.this.viewer instanceof AbstractTreeViewer) {
                    AbstractTreeViewer treeViewer = (AbstractTreeViewer)ResourceExtensionContentProvider.this.viewer;
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(false);
                    }
                    try {
                        if (addedObjects.length > 0) {
                            treeViewer.add((Object)resource, addedObjects);
                        }
                        if (removedObjects.length <= 0) return;
                        treeViewer.remove(removedObjects);
                        return;
                    }
                    finally {
                        if (hasRename) {
                            treeViewer.getControl().setRedraw(true);
                        }
                    }
                } else {
                    ((StructuredViewer)ResourceExtensionContentProvider.this.viewer).refresh((Object)resource);
                }
            }
        };
        runnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(final IResource resource) {
        return new Runnable(){

            @Override
            public void run() {
                ((StructuredViewer)ResourceExtensionContentProvider.this.viewer).refresh((Object)resource);
            }
        };
    }

    private void runUpdates(Collection runnables) {
        Iterator runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }
}

