/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContainerContentProvider
implements ITreeContentProvider {
    private static final Logger log = LogManager.getLogger((String)ContainerContentProvider.class.getName());
    private boolean showClosedProjects = true;
    private boolean showOnlyProjects = false;
    private String projectNatureId;

    public ContainerContentProvider(boolean showOnlyProjects, String projectNatureId) {
        this.showOnlyProjects = showOnlyProjects;
        this.projectNatureId = projectNatureId;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        if (element instanceof IWorkspace) {
            Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.showClosedProjects) {
                return allProjects;
            }
            ArrayList<Object> accessibleProjects = new ArrayList<Object>();
            int i = 0;
            while (i < allProjects.length) {
                Object project = allProjects[i];
                if (project.isOpen()) {
                    if (this.projectNatureId == null) {
                        accessibleProjects.add(project);
                    } else {
                        try {
                            if (project.hasNature(this.projectNatureId)) {
                                accessibleProjects.add(project);
                            }
                        }
                        catch (CoreException e) {
                            log.error("Failed to retrieve nature of project", (Throwable)e);
                        }
                    }
                }
                ++i;
            }
            return accessibleProjects.toArray();
        }
        if (element instanceof IContainer && !this.showOnlyProjects && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                int i = 0;
                while (i < members.length) {
                    if (members[i].getType() != 1 && !members[i].getName().startsWith(".")) {
                        children.add(members[i]);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

