/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPage;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageModel;
import it.jrc.osint.util.ui.wizard.WizardPageController;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectProjectFolderWizardPageController
extends WizardPageController {
    private static final Logger log = LogManager.getLogger((String)SelectProjectFolderWizardPageController.class.getName());
    private SelectProjectFolderWizardPageModel model = new SelectProjectFolderWizardPageModel();
    private SelectProjectFolderWizardPage view;
    private String pageFolderInputLabel = "Select File:";
    private String dialogTitle = "Select Folder";
    private String dialogMessage = "Select a folder inside your workspace";

    public SelectProjectFolderWizardPageController() {
        this.setPageDescription("Select the folder to import files into");
        this.setPageTitle("Folder to import to");
    }

    void setView(SelectProjectFolderWizardPage view) {
        this.view = view;
    }

    @Override
    public IWizardPage getView() {
        if (this.view == null) {
            this.view = new SelectProjectFolderWizardPage("Select import file", this);
        }
        return this.view;
    }

    void showSelectImportFolderDialog(Shell shell) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        dialog.setTitle(this.dialogTitle);
        dialog.setMessage(this.dialogMessage);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        int result = dialog.open();
        this.view.setSelectionValid(false);
        this.view.setErrorMessage(null);
        if (result == 0) {
            Object selectedResource;
            Object[] selectedResources = dialog.getResult();
            if (selectedResources != null && selectedResources.length > 0 && (selectedResource = selectedResources[0]) instanceof IFolder) {
                IFolder selectedFolder = (IFolder)selectedResource;
                this.model.setFolder(selectedFolder);
                this.view.showFilePath(selectedFolder.getFullPath().toString());
                this.view.setSelectionValid(true);
                return;
            }
            this.view.setErrorMessage("Please select a folder within your workspace");
        }
    }

    public void setFolder(IFolder folder) {
        if (folder != null) {
            this.model.setFolder(folder);
        }
    }

    public boolean hasFolder() {
        return this.model.getFolder() != null;
    }

    public IFolder getFolder() {
        return this.model.getFolder();
    }

    public void setDialogTite(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public void setPageFolderInputLabel(String newLabel) {
        this.pageFolderInputLabel = newLabel;
    }

    String getPageFolderInputLabel() {
        return this.pageFolderInputLabel;
    }
}

