/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.controller;

import it.jrc.extract.controller.GuessingThread;
import it.jrc.extract.controller.NestedServletException;
import it.jrc.extract.controller.VariantGuessPool;
import it.jrc.extract.service.VariantException;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GuessingController {
    private static final Logger LOGGER = LogManager.getLogger(GuessingController.class);

    private GuessingController() {
    }

    public static void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, NestedServletException {
        Object[] opMVC = new String[]{"manage"};
        Object[] opText = new String[]{"dophaseout", "endphaseout"};
        Arrays.sort(opMVC);
        Arrays.sort(opText);
        String sop = req.getParameter("op");
        if (sop == null) {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                GuessingController.handleRequestForm(req, res);
            } else {
                req.getRequestDispatcher("guessingmain.jsp").forward((ServletRequest)req, (ServletResponse)res);
            }
        } else if (Arrays.binarySearch(opMVC, sop) > -1) {
            GuessingController.handleRequestMVC(req, sop, res);
        } else if (Arrays.binarySearch(opText, sop) > -1) {
            GuessingController.handleRequestText(req, sop, res);
        } else {
            throw new NestedServletException(400, "the op parameter [" + sop + "] is not amongst the expected ones");
        }
    }

    private static void handleRequestMVC(HttpServletRequest req, String sop, HttpServletResponse res) throws IOException, ServletException, NestedServletException {
        if (sop.equals("manage")) {
            req.setAttribute("vpstatus", VariantGuessPool.getInstance().getStatus());
            req.getRequestDispatcher("guessingmanager.jsp").forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleRequestText(HttpServletRequest req, String sop, HttpServletResponse res) throws IOException, NestedServletException {
        block8: {
            try {
                if (!sop.equals("dophaseout") && !sop.equals("endphaseout")) break block8;
                res.setContentType("text/plain; charset=UTF-8");
                res.setHeader("Cache-Control", "no-cache");
                try (OutputStreamWriter osw = null;){
                    osw = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF-8");
                    osw.write("Command [" + sop + "] sent at " + new Date().toString() + ".\n");
                    osw.write("Wait...\n");
                    osw.flush();
                    if (sop.equals("dophaseout")) {
                        VariantGuessPool.getInstance().doPhaseOut();
                    } else if (sop.equals("endphaseout")) {
                        VariantGuessPool.getInstance().endPhaseOut();
                    }
                    LOGGER.info("op [" + sop + "] done");
                    osw.write("Done.");
                }
            }
            catch (VariantException vex) {
                throw new NestedServletException(500, "cannot handleRequest for op [" + sop + "]", vex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleRequestForm(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, NestedServletException {
        block29: {
            try {
                String source = null;
                FileItem rssxml = null;
                String freetext = null;
                String freelang = null;
                boolean visual = false;
                ServletFileUpload serfilupl = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                serfilupl.setHeaderEncoding("UTF-8");
                List lfilite = serfilupl.parseRequest(req);
                for (FileItem filite : lfilite) {
                    if ("guessingtestsource".equals(filite.getFieldName())) {
                        source = filite.getString();
                    }
                    if ("guessingtestrssxml".equals(filite.getFieldName())) {
                        rssxml = filite;
                    }
                    if ("guessingtestfreetext".equals(filite.getFieldName())) {
                        freetext = filite.getString();
                        freetext = new String(freetext.getBytes("ISO-8859-1"), "UTF-8");
                    }
                    if ("guessingtestfreelang".equals(filite.getFieldName())) {
                        freelang = filite.getString();
                    }
                    if (!"guessingtestvisual".equals(filite.getFieldName())) continue;
                    visual = "on".equals(filite.getString());
                }
                if ("".equals(source)) {
                    throw new NestedServletException(400, "the [guessingtestsource] parameter is missing in the request");
                }
                if ("rss".equals(source) && "".equals(rssxml.getName())) {
                    throw new NestedServletException(400, "the rss xml must be specified");
                }
                if ("free".equals(source) && ("".equals(freetext) || "".equals(freelang))) {
                    throw new NestedServletException(400, "the free text and free text language must be specified");
                }
                RSS rss = null;
                if ("rss".equals(source)) {
                    try (InputStreamReader isr = null;){
                        isr = new InputStreamReader(rssxml.getInputStream(), "UTF-8");
                        try {
                            rss = new RSSParser().parse((Reader)isr);
                        }
                        catch (Exception ex) {
                            throw new NestedServletException(400, "cannot parse InputStreamReader as rss", ex);
                        }
                    }
                    for (RSSItem rssi : rss.getItems()) {
                        ArrayList lse = rssi.getElements("emm:entity");
                        if (lse != null) {
                            for (SimpleElement se : lse) {
                                se.removeAttribute("functions");
                            }
                        }
                        if ((lse = rssi.getElements("emm:guess")) == null) continue;
                        for (SimpleElement se : lse) {
                            rssi.removeElement(se);
                        }
                    }
                } else if ("free".equals(source)) {
                    rss = new RSS();
                    rss.setTitle("free text");
                    rss.setGuid("free text");
                    rss.setLanguage(freelang);
                    RSSItem rssi = new RSSItem();
                    rssi.setTitle("free text");
                    rssi.setGuid("free text");
                    rssi.setLanguage(freelang);
                    rssi.setText(freetext);
                    rss.addItem(rssi);
                }
                GuessingThread gt = new GuessingThread(GuessingThread.class.getName() + "-t", null, null, null);
                long t = System.currentTimeMillis();
                gt.guessing(rss, true);
                t = System.currentTimeMillis() - t;
                String usedlanguage = rss.getLanguage();
                if (Arrays.binarySearch(VariantGuessPool.getInstance().getVariantGuessLanguages(), rss.getLanguage()) < 0) {
                    usedlanguage = "en";
                }
                if (visual) {
                    req.setAttribute("source", (Object)("rss".equals(source) ? rssxml.getName() : "free text"));
                    req.setAttribute("rss", (Object)rss);
                    req.setAttribute("duration", (Object)(String.valueOf(t) + " ms"));
                    req.setAttribute("usedlanguage", (Object)usedlanguage);
                    req.getRequestDispatcher("guessinghighlight.jsp").forward((ServletRequest)req, (ServletResponse)res);
                    break block29;
                }
                res.setContentType("application/xml; charset=UTF-8");
                res.setHeader("Cache-Control", "no-cache");
                try (OutputStreamWriter osw = null;){
                    osw = new OutputStreamWriter((OutputStream)res.getOutputStream(), "UTF-8");
                    rss.toXML((Writer)osw);
                    osw.flush();
                }
            }
            catch (VariantException vex) {
                throw new NestedServletException(500, "cannot handleRequest for op [submitrss]", vex);
            }
            catch (FileUploadException fuex) {
                throw new NestedServletException(500, "cannot handleRequest for op [submitrss]", fuex);
            }
        }
    }
}

