/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.extract.model;

public final class Variant {
    private long _key = -1L;
    private long _id = -1L;
    private String _type = null;
    private String _source = null;
    private String _variant = null;
    private String _languages = null;
    private int _changes = 0;

    private Variant() {
    }

    public Variant(long key, long id, String type, String source, String variant, String languages) {
        this();
        this._key = key;
        this._id = id;
        this._type = type;
        this._source = source;
        this._variant = variant;
        this._languages = languages;
    }

    public long getKey() {
        return this._key;
    }

    public long getId() {
        return this._id;
    }

    public void setId(long id) {
        if (this._key == -1L) {
            throw new AssertionError((Object)"setId can be called on a variant instantiated from the database (where _key != -1)");
        }
        if (this._id == -1L) {
            throw new AssertionError((Object)"setId can be called on a variant instantiated from the database (where _id != -1)");
        }
        if (this._type == null) {
            throw new AssertionError((Object)"setId can be called on a variant instantiated from the database (where _type != null)");
        }
        this._id = id;
        this._changes |= 1;
    }

    public boolean wasIdChanged() {
        boolean result = (this._changes & 1) == 1;
        this._changes &= 0xFFFFFFFE;
        return result;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (this._key == -1L) {
            throw new AssertionError((Object)"setType can be called on a variant instantiated from the database (where _key != -1)");
        }
        if (this._id == -1L) {
            throw new AssertionError((Object)"setType can be called on a variant instantiated from the database (where _id != -1)");
        }
        if (this._type == null) {
            throw new AssertionError((Object)"setType can be called on a variant instantiated from the database (where _type != null)");
        }
        this._type = type;
        this._changes |= 2;
    }

    public boolean wasTypeChanged() {
        boolean result = (this._changes & 2) == 2;
        this._changes &= 0xFFFFFFFD;
        return result;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String source) {
        if (this._key == -1L) {
            throw new AssertionError((Object)"setSource can be called on a variant instantiated from the database (where _key != -1)");
        }
        if (this._id == -1L) {
            throw new AssertionError((Object)"setSource can be called on a variant instantiated from the database (where _id != -1)");
        }
        if (this._type == null) {
            throw new AssertionError((Object)"setSource can be called on a variant instantiated from the database (where _type != null)");
        }
        this._source = source;
        this._changes |= 4;
    }

    public boolean wasSourceChanged() {
        boolean result = (this._changes & 4) == 4;
        this._changes &= 0xFFFFFFFB;
        return result;
    }

    public String getVariant() {
        return this._variant;
    }

    public void setVariant(String variant) {
        this._variant = variant;
        this._changes |= 8;
    }

    public boolean wasVariantChanged() {
        boolean result = (this._changes & 8) == 8;
        this._changes &= 0xFFFFFFF7;
        return result;
    }

    public String getLanguages() {
        return this._languages;
    }

    public String[] getLanguagesAsArray() {
        if (this._languages != null) {
            return this._languages.split(",");
        }
        return new String[0];
    }

    public boolean isValid() {
        return this._languages == null;
    }

    public void setValid() {
        this._languages = null;
        this._changes |= 0x10;
    }

    public boolean isInvalid() {
        return "-u,".equals(this._languages);
    }

    public void setInvalid() {
        this._languages = "-u,";
        this._changes |= 0x10;
    }

    public boolean isValidIn(String language) {
        return this._languages != null && this._languages.contains("+" + language + ",");
    }

    public void setValidIn(String[] languages) {
        this._languages = "";
        for (String s : languages) {
            this._languages = this._languages.concat("+" + s + ",");
        }
        this._changes |= 0x10;
    }

    public boolean isInvalidIn(String language) {
        return this._languages != null && this._languages.contains("-" + language + ",");
    }

    public void setInvalidIn(String[] languages) {
        this._languages = "";
        for (String s : languages) {
            this._languages = this._languages.concat("-" + s + ",");
        }
        this._changes |= 0x10;
    }

    public boolean wasLanguageChanged() {
        boolean result = (this._changes & 0x10) == 16;
        this._changes &= 0xFFFFFFEF;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant lobj = (Variant)obj;
        return lobj._variant.equals(this._variant);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this._variant.hashCode();
        return result;
    }
}

