/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.optima.lang;

import it.jrc.emmtools.LanguageMatch;
import it.jrc.emmtools.LanguageScore;
import it.jrc.emmutils.FileExtFilter;
import it.jrc.emmutils.HTTPStream;
import it.jrc.matcher.MatchResult;
import it.jrc.matcher.MatchWords;
import it.jrc.rss.RSSItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageDetector {
    private static final Logger logger = LogManager.getLogger((String)"it.jrc.optima.lang.LanguageDetector");
    private String resourcePath;
    private String languageDefDir;
    private MatchWords matcher = MatchWords.getInstance((String)"LanguageDetector");
    private LanguageMatch matchResult;
    private HashMap<String, Vector<RSSItem>> languageItems = null;
    private Iterator<Vector<RSSItem>> langIterator = null;
    private ArrayList<String> languages = null;

    public LanguageDetector(String resourcePath) throws IOException {
        this.resourcePath = resourcePath;
        this.initLanguages(resourcePath);
    }

    public RSSItem process(RSSItem inputItem) {
        this.matchResult.init();
        this.matcher.match(inputItem.getTitle() + inputItem.getText(), (MatchResult)this.matchResult);
        LanguageScore[] scores = this.matchResult.getScores();
        String itemLanguage = inputItem.getLanguage();
        if (itemLanguage == null) {
            inputItem.setLanguage(scores[0].language);
            logger.info("language found = " + scores[0].language + "  with score = " + scores[0].score);
        } else {
            logger.info("found item in " + itemLanguage + " language.");
            String language = itemLanguage;
            if (scores[0].score == 0.0) {
                logger.info("could not detect language for " + inputItem.getTitle() + "(" + inputItem.getGuid() + ")");
            } else if (scores[0].score > 90.0 && !scores[0].language.equals(itemLanguage)) {
                language = scores[0].language;
                if ((!language.equals("mo") && !language.equals("ro") || !itemLanguage.equals("mo") && !itemLanguage.equals("ro")) && (!language.equals("hr") && !language.equals("sr") && !language.equals("bs") || !itemLanguage.equals("hr") && !itemLanguage.equals("sr") && !itemLanguage.equals("bs")) && (!language.equals("uk") && !language.equals("ru") && !language.equals("be") || !itemLanguage.equals("uk") && !itemLanguage.equals("ru") && !itemLanguage.equals("be"))) {
                    logger.info("language " + language + " found instead of " + itemLanguage + " for " + inputItem.getTitle() + "(" + inputItem.getGuid() + ")");
                    inputItem.setLanguage(language);
                }
            } else {
                logger.info("language found = " + scores[0].language + "  with score = " + scores[0].score);
            }
        }
        return inputItem;
    }

    private void initLanguages(String resourcePath) throws IOException {
        try {
            this.languageDefDir = resourcePath;
            Hashtable<String, StringBuilder> words = new Hashtable<String, StringBuilder>();
            this.languages = new ArrayList();
            File dir = new File(this.languageDefDir);
            File[] languageFiles = dir.listFiles((FilenameFilter)new FileExtFilter(".def"));
            logger.info("found " + languageFiles.length + " languages in " + this.languageDefDir);
            for (int languageIndex = 0; languageIndex < languageFiles.length; ++languageIndex) {
                File f = languageFiles[languageIndex];
                int ind = f.getName().indexOf(".def");
                String lan = f.getName().substring(0, ind);
                logger.info("reading words for " + lan);
                this.languages.add(lan);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
                String word = br.readLine();
                for (char weight = '\u00c8'; word != null && weight > '\u0000'; weight = (char)(weight - '\u0001')) {
                    StringBuilder sb = (StringBuilder)words.get(word);
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append('\u0000');
                    }
                    sb.append((char)languageIndex).append(weight);
                    int nLan = sb.charAt(0) + '\u0001';
                    sb.setCharAt(0, (char)nLan);
                    words.put(word, sb);
                    word = br.readLine();
                }
            }
            this.matcher.init(words);
            this.matchResult = new LanguageMatch(this.languages);
        }
        catch (IOException e) {
            logger.error("Failed to initialize language detection", (Throwable)e);
            throw e;
        }
    }

    public void retrieveLatestDefinitions(String resourceURL) {
        try {
            this.languageDefDir = this.resourcePath;
            ZipInputStream resourceZip = new ZipInputStream((InputStream)new HTTPStream(resourceURL));
            ZipEntry resourceDir = resourceZip.getNextEntry();
            while (resourceDir != null && resourceDir.isDirectory()) {
                String dir = resourceDir.getName();
                String language = dir.substring(0, dir.length() - 1);
                ZipEntry resourceFile = resourceZip.getNextEntry();
                if (!resourceFile.isDirectory()) {
                    File languageDef = new File(this.languageDefDir + "/" + language + ".def");
                    FileOutputStream out = new FileOutputStream(languageDef);
                    int chunkSize = 16384;
                    byte[] ba = new byte[chunkSize];
                    int bytesRead = resourceZip.read(ba, 0, chunkSize);
                    while (bytesRead >= 0) {
                        ((OutputStream)out).write(ba, 0, bytesRead);
                        bytesRead = resourceZip.read(ba, 0, chunkSize);
                    }
                    out.flush();
                    ((OutputStream)out).close();
                    resourceZip.closeEntry();
                    resourceDir = resourceZip.getNextEntry();
                    continue;
                }
                resourceDir = resourceFile;
            }
        }
        catch (Exception e) {
            logger.error("could not produce language resource definitions", (Throwable)e);
        }
    }
}

