/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import it.jrc.alert.PatternCombination;
import it.jrc.emmutils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Alert {
    private static final boolean DEBUG = false;
    private static Logger logger = LogManager.getLogger((String)"it.jrc.alert.Alert");
    private String sID;
    private String sDescription = null;
    private String sContact = null;
    private String sClass = null;
    private String sDefinitionFile = null;
    private int nThreshold;
    private boolean bThreshold = false;
    private int nMaxArticles = 10;
    private long span = -1L;
    private File xml;
    private ArrayList<PatternCombination> combinations = null;
    private int nArticles;
    private int nIndex = 0;
    private int nNew = 0;
    private String duplicate;
    private boolean bRunning = false;

    public void setID(String s) {
        this.sID = s;
    }

    public void setDescription(String s) {
        this.sDescription = s;
    }

    public void setContact(String s) {
        this.sContact = s;
    }

    public void setDefinitionFile(String s) {
        this.sDefinitionFile = s;
    }

    public void setInit() {
        this.nNew = 0;
        this.bRunning = true;
    }

    public void setThreshold(int n) {
        this.nThreshold = n;
        this.bThreshold = true;
    }

    public void setAlertClass(String s) {
        this.sClass = s;
    }

    public void setMaxArticles(int n) {
        this.nMaxArticles = n;
    }

    public void setXMLFile(File f) {
        this.xml = f;
    }

    public void setMustContain(ArrayList<PatternCombination> v) {
        this.combinations = v;
    }

    public String getID() {
        return this.sID;
    }

    public int getThreshold() {
        return this.nThreshold;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public String getDefinitionFile() {
        return this.sDefinitionFile;
    }

    public String getContact() {
        return this.sContact;
    }

    public String getAlertClass() {
        return this.sClass;
    }

    public int getMaxArticles() {
        return this.nMaxArticles;
    }

    public File getXMLFile() {
        return this.xml;
    }

    public int exceedsThreshold(double[] dScore) {
        if (this.bThreshold && dScore[dScore.length - 1] >= (double)this.nThreshold) {
            int i;
            for (i = 0; i < dScore.length && dScore[i] < (double)this.nThreshold; ++i) {
            }
            if (i >= dScore.length) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    public int containsCombi(HashMap<String, ArrayList<Integer>> patternsFound, int nNumerator) {
        if (this.combinations != null) {
            boolean bCombi = false;
            int nCombi = 0;
            int index = -1;
            while (index < 0 && nCombi < this.combinations.size()) {
                PatternCombination combi = this.combinations.get(nCombi++);
                index = combi.matches(patternsFound);
            }
            if (index >= 0) {
                return index / nNumerator;
            }
            return -1;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sOut = new StringBuilder(256);
        sOut.append("<alert id=\"" + this.sID + "\">");
        sOut.append("<description>");
        if (this.sDescription != null) {
            sOut.append(Utils.encodeXML((String)this.sDescription));
        }
        sOut.append("</description>");
        sOut.append("<contact>");
        if (this.sContact != null) {
            sOut.append(Utils.encodeXML((String)this.sContact));
        }
        sOut.append("</contact>");
        if (this.sClass != null) {
            sOut.append("<class>");
            sOut.append(Utils.encodeXML((String)this.sClass));
            sOut.append("</class>");
        }
        if (this.nMaxArticles >= 0) {
            sOut.append("<maxArticles>" + this.nMaxArticles + "</maxArticles>");
        }
        if (this.span > 0L) {
            sOut.append("<span>" + this.span + "</span>");
        }
        sOut.append("<definition>" + this.sDefinitionFile + "</definition>");
        sOut.append("</alert>");
        return sOut.toString();
    }
}

