/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PatternCombination {
    private ArrayList<ArrayList<String>> combinations = new ArrayList();
    private ArrayList<String> not = null;
    private int maxDistance = -1;
    private static boolean DEBUG = false;

    public PatternCombination() {
    }

    public PatternCombination(int max) {
        this();
        this.maxDistance = max;
    }

    public void addCombination(ArrayList<String> v) {
        this.combinations.add(v);
    }

    public void addNot(ArrayList<String> v) {
        this.not = v;
    }

    public ArrayList<ArrayList<String>> getCombinations() {
        return this.combinations;
    }

    private int[] orderedArray(ArrayList<Integer> elements, boolean sort) {
        int[] ordered = new int[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            ordered[i] = elements.get(i);
        }
        if (sort) {
            Arrays.sort(ordered);
        }
        return ordered;
    }

    private int inRange(ArrayList<int[]> indices, int maxDist) {
        int minIndex = -1;
        int[] ind0 = indices.get(0);
        int[] ind1 = indices.get(1);
        if (indices.size() == 2) {
            int i = 0;
            boolean found = false;
            int limit = ind1[ind1.length - 1] + maxDist;
            int index0 = -1;
            int index1 = -1;
            while (i < ind0.length && ind0[i] <= limit && !found) {
                index0 = ind0[i++];
                int j = 0;
                while (j < ind1.length && !found) {
                    found = Math.abs((index1 = ind1[j++]) - index0) <= maxDist;
                }
            }
            if (found) {
                minIndex = Math.max(index0, index1);
            }
        } else {
            int maxPairs = ind0.length * ind1.length;
            int[] lower = new int[maxPairs];
            int[] upper = new int[maxPairs];
            int nPairs = 0;
            boolean bLimit = false;
            int limit = ind1[ind1.length - 1] + maxDist;
            for (int i = 0; i < ind0.length && ind0[i] <= limit; ++i) {
                int index0 = ind0[i];
                boolean bNextI = false;
                for (int j = 0; j < ind1.length && !bNextI; ++j) {
                    int dist;
                    int index1;
                    if (DEBUG) {
                        System.out.println("checking " + i + "," + j);
                    }
                    if (index0 < (index1 = ind1[j])) {
                        dist = index1 - index0;
                        if (dist > maxDist) {
                            bNextI = true;
                            continue;
                        }
                        lower[nPairs] = index0;
                        upper[nPairs++] = index1;
                        if (!DEBUG) continue;
                        System.out.println("we have a valid pair! " + index0 + "," + index1);
                        continue;
                    }
                    dist = index0 - index1;
                    if (dist > maxDist) continue;
                    lower[nPairs] = index1;
                    upper[nPairs++] = index0;
                    if (!DEBUG) continue;
                    System.out.println("we have a valid pair! " + index0 + "," + index1);
                    if (!DEBUG || !bNextI) continue;
                    System.out.println("skip to next i! " + (i + 1));
                }
            }
            for (int nPattern = 2; nPattern < indices.size() && nPairs > 0; ++nPattern) {
                if (DEBUG) {
                    System.out.println("checking next list of indices: valid combinations so far " + nPairs);
                }
                int[] ind = indices.get(nPattern);
                int[] newLower = new int[nPairs * ind.length];
                int[] newUpper = new int[nPairs * ind.length];
                int nCombo = 0;
                for (int k = 0; k < ind.length; ++k) {
                    int index = ind[k];
                    for (int j = 0; j < nPairs; ++j) {
                        int l = upper[j] - maxDist;
                        int u = lower[j] + maxDist;
                        if (index < l || index > u) continue;
                        newLower[nCombo] = lower[j];
                        newUpper[nCombo] = upper[j];
                        if (index < lower[j]) {
                            newLower[nCombo] = index;
                        } else if (index > upper[j]) {
                            newUpper[nCombo] = index;
                        }
                        ++nCombo;
                        if (!DEBUG) continue;
                        System.out.println("combined next pattern @" + index + " min,max " + lower[j] + "," + upper[j]);
                    }
                }
                nPairs = nCombo;
                upper = newUpper;
                lower = newLower;
            }
            if (nPairs > 0) {
                minIndex = upper[0];
            }
        }
        return minIndex;
    }

    public int matches(HashMap<String, ArrayList<Integer>> patternsFound) {
        boolean bMatch = true;
        int nCombi = 0;
        int minIndex = -1;
        ArrayList<int[]> indices = new ArrayList<int[]>();
        while (bMatch && nCombi < this.combinations.size()) {
            ArrayList<String> or = this.combinations.get(nCombi++);
            boolean bOr = false;
            int nPatterns = 0;
            ArrayList<Integer> orListIndices = new ArrayList<Integer>();
            for (String pattern : or) {
                ArrayList<Integer> patternIndices = patternsFound.get(pattern);
                if (patternIndices == null) continue;
                orListIndices.addAll(patternIndices);
                ++nPatterns;
            }
            boolean bl = bOr = orListIndices.size() > 0;
            if (bOr) {
                int[] pIndices = this.orderedArray(orListIndices, nPatterns > 1);
                indices.add(pIndices);
                int index = pIndices[0];
                if (index > minIndex) {
                    minIndex = index;
                }
            }
            bMatch = bMatch && bOr;
        }
        if (bMatch && null != this.not) {
            boolean bNot = false;
            int nNot = 0;
            while (!bNot && nNot < this.not.size()) {
                bNot = patternsFound.containsKey(this.not.get(nNot++));
            }
            boolean bl = bMatch = !bNot;
        }
        if (bMatch && this.maxDistance > 0 && nCombi > 1) {
            minIndex = this.inRange(indices, this.maxDistance);
        }
        if (bMatch) {
            return minIndex;
        }
        return -1;
    }
}

