/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipUtil {
    private static final Logger log = LogManager.getLogger((String)ZipUtil.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static final byte[] compress(String uncompressed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            byte[] uncompressedBytes = uncompressed.getBytes();
            gzos.write(uncompressedBytes, 0, uncompressedBytes.length);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static final String uncompress(byte[] compressed) throws IOException {
        if (compressed == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        GZIPInputStream gzis = new GZIPInputStream(bais);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String uncompressed;
            int numBytesRead = 0;
            byte[] tempBytes = new byte[4096];
            while ((numBytesRead = gzis.read(tempBytes, 0, tempBytes.length)) != -1) {
                baos.write(tempBytes, 0, numBytesRead);
            }
            String string = uncompressed = new String(baos.toByteArray());
            return string;
        }
        catch (Throwable t) {
            log.error("Uncompressing of String failed", t);
            throw new IOException("Uncompressing of string failed", t);
        }
        finally {
            if (gzis != null) {
                gzis.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }
}

