/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.cache;

import it.jrc.osint.util.cache.Cache;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SoftReferenceCache<K, V>
implements Cache<K, V> {
    private Map<K, SoftReference<V>> entries = new ConcurrentHashMap<K, SoftReference<V>>();

    @Override
    public boolean contains(K key) {
        SoftReference<V> value;
        return this.entries.containsKey(key) && (value = this.entries.get(key)).get() != null;
    }

    @Override
    public V get(K key) {
        if (this.contains(key)) {
            return this.entries.get(key).get();
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        this.entries.put(key, new SoftReference<V>(value));
    }

    @Override
    public V remove(K key) {
        if (this.contains(key)) {
            return this.entries.remove(key).get();
        }
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }
}

