/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.concurrent;

import it.jrc.osint.Identifiable;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.ProcessingContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingIteratorConsumer<T>
implements Consumer<T>,
Iterator<T> {
    private static final Logger log = LogManager.getLogger((String)BlockingIteratorConsumer.class.getName());
    private BlockingQueue<T> blockingQueue = new LinkedBlockingQueue<T>();
    private boolean finished = false;
    private int consumedItemCount = 0;
    private Set<String> consumedIds = new HashSet<String>();

    @Override
    public void reset() {
        this.finished = false;
        this.blockingQueue.clear();
        this.consumedItemCount = 0;
        this.consumedIds.clear();
    }

    @Override
    public Set<String> getConsumedItemIds() {
        return this.consumedIds;
    }

    @Override
    public void consume(T anItem) {
        ++this.consumedItemCount;
        this.blockingQueue.add(anItem);
        if (anItem instanceof Identifiable) {
            this.consumedIds.add(((Identifiable)anItem).getId());
        }
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public void setContext(ProcessingContext context) {
    }

    @Override
    public int consumedItemCount() {
        return this.consumedItemCount;
    }

    @Override
    public T next() {
        T nextItem = null;
        do {
            try {
                nextItem = this.blockingQueue.poll(2L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                log.error("Failed to poll internal queue", t);
            }
        } while (nextItem == null && !this.finished);
        return nextItem;
    }

    @Override
    public boolean hasNext() {
        return !this.finished || !this.blockingQueue.isEmpty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

