/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.concurrent;

import it.jrc.osint.util.concurrent.AbstractProducer;
import it.jrc.osint.util.concurrent.ProcessingContext;
import java.util.Collection;
import java.util.Iterator;

public class CollectionProducer<T>
extends AbstractProducer<T> {
    private Collection<T> theCollection;
    private Iterator<T> theIterator = new EmptyIterator();

    public CollectionProducer(Collection<T> aCollection) {
        this.theCollection = aCollection;
        this.theIterator = this.theCollection.iterator();
    }

    @Override
    public void setContext(ProcessingContext context) {
        super.setContext(context);
    }

    @Override
    public boolean hasNext() {
        return this.theIterator.hasNext();
    }

    @Override
    public T next() {
        return this.theIterator.next();
    }

    @Override
    public int expectedItemCount() {
        return this.theCollection.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.theIterator;
    }

    @Override
    public void reset() {
        this.theIterator = this.theCollection.iterator();
    }

    private class EmptyIterator
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

