/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.config;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyUtil {
    private static final Logger log = LogManager.getLogger((String)PropertyUtil.class.getName());

    public static Properties loadProperties(String fileName) {
        File propertiesFile = new File(fileName);
        if (!propertiesFile.exists()) {
            return null;
        }
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(fileName);
            Properties resultProperties = new Properties();
            resultProperties.load(fileIn);
            Properties properties = resultProperties;
            return properties;
        }
        catch (IOException e) {
            log.error("Could not load properties from " + fileName, (Throwable)e);
            return null;
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    log.error("Could not close FileInputStream for file " + fileName + " properly", (Throwable)e);
                }
            }
        }
    }

    public static void storeProperties(String fileName, Properties theProperties, String comment) {
        block12: {
            FileOutputStream fileOut = null;
            try {
                try {
                    fileOut = new FileOutputStream(fileName);
                    theProperties.store(fileOut, comment);
                }
                catch (IOException e) {
                    log.error("Could not store properties to file: " + fileName + " with comment " + comment, (Throwable)e);
                    if (fileOut == null) break block12;
                    try {
                        fileOut.close();
                    }
                    catch (IOException e2) {
                        log.error("Could not close FileOutputStream properly", (Throwable)e2);
                    }
                }
            }
            finally {
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e) {
                        log.error("Could not close FileOutputStream properly", (Throwable)e);
                    }
                }
            }
        }
    }
}

