/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.text;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;

public class StringUtil {
    private static final Logger log = LogManager.getLogger((String)StringUtil.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static final byte[] compress(String uncompressed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        byte[] uncompressedBytes = uncompressed.getBytes();
        gzos.write(uncompressedBytes, 0, uncompressedBytes.length);
        gzos.close();
        return baos.toByteArray();
    }

    public static final String uncompress(byte[] compressed) throws IOException {
        if (compressed == null) {
            return null;
        }
        String uncompressed = "";
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            GZIPInputStream gzis = new GZIPInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int numBytesRead = 0;
            byte[] tempBytes = new byte[4096];
            while ((numBytesRead = gzis.read(tempBytes, 0, tempBytes.length)) != -1) {
                baos.write(tempBytes, 0, numBytesRead);
            }
            uncompressed = new String(baos.toByteArray());
        }
        catch (ZipException e) {
            log.error("Uncompressing of String failed", (Throwable)e);
        }
        return uncompressed;
    }

    public static boolean containsInteger(String aString) {
        try {
            Integer.parseInt(aString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static List<String> splitLineSeparatedString(String contentStr) {
        LinkedList<String> resultList = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(contentStr, System.getProperty("line.separator"));
        while (st.hasMoreTokens()) {
            resultList.add(st.nextToken());
        }
        return resultList;
    }
}

