/*
 * Decompiled with CFR 0.152.
 */
package test.util.concurrent;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.AbstractProducer;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.ParallelProcessor;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.ProcessorParameters;
import it.jrc.osint.util.test.TestUtil;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.util.concurrent.FailingStringTask;
import test.util.concurrent.ListConsumer;
import test.util.concurrent.StringConcatTask;

public class TestParallelProcessor {
    private static final Logger log = LogManager.getLogger((String)TestParallelProcessor.class.getName());

    @Before
    public void setup() {
        TestUtil.setupLogging();
    }

    @Test
    public void processStringsSerial() throws ProcessingException {
        StringProducer stringProducer = new StringProducer();
        ListConsumer stringConsumer = new ListConsumer();
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new StringConcatTask());
        stringProcessor.setThreadPoolSize(1);
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        try {
            processorFuture.get();
        }
        catch (Exception e) {
            Assert.fail((String)"Processing was aborted");
        }
    }

    @Test
    public void processMonitored() throws ProcessingException {
        StringProducer stringProducer = new StringProducer();
        ListConsumer stringConsumer = new ListConsumer();
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new StringConcatTask());
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        try {
            processorFuture.get();
        }
        catch (Exception e) {
            Assert.fail((String)"Processing was aborted");
        }
    }

    @Test
    public void processStringParallel() throws ProcessingException, InterruptedException, ExecutionException {
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(new StringProducer(100), new ListConsumer(), new StringConcatTask());
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        ListConsumer finishedConsumer = (ListConsumer)processorFuture.get();
        Assert.assertEquals((String)"Consumer did not receive all processed items", (long)100L, (long)finishedConsumer.getList().size());
    }

    @Test
    public void processFailingTask() throws ProcessingException {
        StringProducer stringProducer = new StringProducer();
        ListConsumer stringConsumer = new ListConsumer();
        ProcessorParameters processorParams = new ProcessorParameters();
        processorParams.setConsumerQueueCapacity(100);
        processorParams.setProducerQueueCapacity(100);
        processorParams.setThreadPoolSize(10);
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new FailingStringTask());
        stringProcessor.setParameters(processorParams);
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        try {
            processorFuture.get();
        }
        catch (Exception e) {
            Assert.fail((String)"Processing was aborted");
        }
        Assert.assertTrue((String)"Failed items not in failed items list", (stringProcessor.getFailedInput().size() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelProcessing() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(100);
        ListConsumer stringConsumer = new ListConsumer();
        ProcessorParameters processorParams = new ProcessorParameters();
        processorParams.setConsumerQueueCapacity(10);
        processorParams.setProducerQueueCapacity(10);
        processorParams.setThreadPoolSize(1);
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new StringConcatTask());
        stringProcessor.setParameters(processorParams);
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        TestParallelProcessor testParallelProcessor = this;
        synchronized (testParallelProcessor) {
            try {
                this.wait(3000L);
                processorFuture.cancel(false);
                this.wait(10000L);
                Assert.assertTrue((String)"Cancel failed, all items were processed", (stringConsumer.consumedItemCount() < 100 ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void futureTimeout() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(1000);
        ListConsumer stringConsumer = new ListConsumer();
        ProcessorParameters processorParams = new ProcessorParameters();
        processorParams.setConsumerQueueCapacity(10);
        processorParams.setProducerQueueCapacity(10);
        processorParams.setThreadPoolSize(1);
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new StringConcatTask());
        stringProcessor.setParameters(processorParams);
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        TestParallelProcessor testParallelProcessor = this;
        synchronized (testParallelProcessor) {
            try {
                this.wait(1000L);
                processorFuture.get(1000L, TimeUnit.MILLISECONDS);
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelProcessingImmediately() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(100);
        ListConsumer stringConsumer = new ListConsumer();
        ProcessorParameters processorParams = new ProcessorParameters();
        processorParams.setConsumerQueueCapacity(10);
        processorParams.setProducerQueueCapacity(10);
        processorParams.setThreadPoolSize(1);
        ParallelProcessor<String> stringProcessor = new ParallelProcessor<String>(stringProducer, stringConsumer, new StringConcatTask());
        stringProcessor.setParameters(processorParams);
        Future<Consumer<String>> processorFuture = stringProcessor.start(null);
        TestParallelProcessor testParallelProcessor = this;
        synchronized (testParallelProcessor) {
            try {
                this.wait(3000L);
                processorFuture.cancel(true);
                this.wait(10000L);
                Assert.assertTrue((String)"Cancel failed, all items were processed", (stringConsumer.consumedItemCount() < 100 ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class StringProducer
    extends AbstractProducer<String> {
        private int itemsToProduce;
        private int i;

        public StringProducer() {
            this(100);
        }

        public StringProducer(int itemsToProduce) {
            this.itemsToProduce = itemsToProduce;
            this.i = 0;
        }

        @Override
        public int expectedItemCount() {
            return this.itemsToProduce;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.itemsToProduce;
        }

        @Override
        public String next() {
            String numberStr = "" + this.i++;
            return numberStr;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                this.setContext(null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return this;
        }

        @Override
        public void reset() {
            this.i = 0;
        }
    }
}

