/*
 * Decompiled with CFR 0.152.
 */
package test.util.io;

import it.jrc.osint.util.io.CharsetUtil;
import it.jrc.osint.util.test.TestUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCharsetUtil {
    private String baseDir = TestUtil.getTestBaseDir("charset");

    @Before
    public void setup() {
        TestUtil.setupLogging();
    }

    @Test
    public void testUtf8() {
        String testFilePath = String.valueOf(this.baseDir) + File.separator + "utf-8.txt";
        File utf8File = new File(testFilePath);
        try {
            Charset guessedCharset = CharsetUtil.guessEncoding(utf8File, 4096);
            Assert.assertEquals((String)guessedCharset.name(), (String)"UTF-8");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occurred");
        }
    }

    @Test
    public void testWindows1252() {
        String testFilePath = String.valueOf(this.baseDir) + File.separator + "windows-1252.txt";
        File cp1252File = new File(testFilePath);
        try {
            Charset guessedCharset = CharsetUtil.guessEncoding(cp1252File, 4096);
            Assert.assertEquals((String)guessedCharset.name(), (String)"windows-1252");
        }
        catch (IOException e) {
            Assert.fail((String)"IOException occurred");
        }
    }
}

