/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.index.internal;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.extract.text.TextExtractionServiceEvent;
import it.jrc.osint.index.IndexPlugin;
import it.jrc.osint.index.IndexService;
import it.jrc.osint.index.IndexServiceEvent;
import it.jrc.osint.index.internal.IndexServiceEventImpl;
import it.jrc.osint.index.internal.RebuildIndexJob;
import it.jrc.osint.index.internal.SearchIndexJob;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.SystemUtil;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class IndexServiceImpl
implements IndexService {
    private static final Logger log = LogManager.getLogger((String)IndexServiceImpl.class.getName());
    private IndexWriter globalIndex;
    private WorkspaceService ws;
    private EventBroker eventBroker;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private IPath stateLocation;

    public IndexServiceImpl(EventBroker eb, WorkspaceService ws, IPath stateLocation) {
        this.eventBroker = eb;
        this.ws = ws;
        this.stateLocation = stateLocation;
    }

    public void start() {
        this.eventBroker.register(new String[]{"osint/workspace/resourceDeleted", "osint/workspace/resourceMoved", "osint/textExtraction/extractionSuccess"}, this.topicEventListener);
        this.performRebuildIndex();
    }

    @Override
    public IndexWriter getGlobalIndex() {
        return this.globalIndex;
    }

    public void setGlobalIndex(IndexWriter iw) {
        this.globalIndex = iw;
    }

    @Override
    public void performRebuildIndex() {
        IndexServiceEventImpl initUpdatingIndexEvent = new IndexServiceEventImpl("osint/index/startUpdateIndex");
        DisableSearchJob disablesearchjob = new DisableSearchJob("Disabling the local search");
        disablesearchjob.addJobChangeListener((IJobChangeListener)new JobChangeListener(initUpdatingIndexEvent));
        disablesearchjob.setUser(false);
        disablesearchjob.setPriority(20);
        disablesearchjob.schedule();
        IndexServiceEventImpl finishUpdatingIndexEvent = new IndexServiceEventImpl("osint/index/finishUpdateIndex");
        RebuildIndexJob rebuildindexjob = new RebuildIndexJob("Updating local index");
        rebuildindexjob.addJobChangeListener((IJobChangeListener)new JobChangeListener(finishUpdatingIndexEvent));
        rebuildindexjob.setUser(false);
        rebuildindexjob.schedule();
    }

    @Override
    public void createIndex() {
        try {
            Object dir = null;
            dir = SystemUtil.isX86_64() && SystemUtil.isWin() ? FSDirectory.open((File)this.stateLocation.toFile()) : (SystemUtil.isLinux() || SystemUtil.isMac() ? new NIOFSDirectory(this.stateLocation.toFile()) : new SimpleFSDirectory(this.stateLocation.toFile()));
            StandardAnalyzer analyzer = new StandardAnalyzer(IndexPlugin.lucene_version);
            IndexWriterConfig iwc = new IndexWriterConfig(IndexPlugin.lucene_version, (Analyzer)analyzer);
            iwc.setMaxBufferedDeleteTerms(1);
            if (DirectoryReader.indexExists((Directory)dir)) {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
                log.debug("Global index already exists");
            } else {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
                log.debug("New global index generated in " + this.stateLocation.toOSString());
            }
            this.setGlobalIndex(new IndexWriter((Directory)dir, iwc));
        }
        catch (Exception e) {
            log.error("Failed to create new index.", (Throwable)e);
        }
    }

    @Override
    public boolean addFilesInGlobalIndex(Set<ResourceId> setdocs) {
        ArrayList<Document> setlucenedocs = new ArrayList<Document>();
        for (ResourceId filerid : setdocs) {
            CaseProject cp = this.ws.getCaseProjectByDocumentId(filerid);
            DocumentMetaItem dmi = cp.getMetaItem(filerid);
            Document doc = new Document();
            String newid = filerid.toString().replaceAll("-", "").toLowerCase();
            StringField primarykey = new StringField("primary_key_id", newid, Field.Store.YES);
            doc.add((IndexableField)primarykey);
            StringField rid = new StringField("resource_id", filerid.toString(), Field.Store.YES);
            doc.add((IndexableField)rid);
            StringField idproject = new StringField("project_id", cp.getId().toString(), Field.Store.YES);
            doc.add((IndexableField)idproject);
            StringField titlefield = new StringField("title", this.getTitle(filerid), Field.Store.YES);
            doc.add((IndexableField)titlefield);
            StringField typefield = new StringField("type", this.getType(filerid), Field.Store.YES);
            doc.add((IndexableField)typefield);
            StringField filepath = new StringField("path", this.getPath(filerid), Field.Store.YES);
            doc.add((IndexableField)filepath);
            TextField contents = new TextField("content", dmi.getText(), Field.Store.NO);
            doc.add((IndexableField)contents);
            setlucenedocs.add(doc);
        }
        try {
            this.globalIndex.addDocuments(setlucenedocs);
            this.globalIndex.commit();
            log.info("Added " + setlucenedocs.size() + " new documents to the global index");
            return true;
        }
        catch (Exception e) {
            log.error("addFilesInGlobalIndex: " + e.toString());
            return false;
        }
    }

    @Override
    public boolean checkFileInGlobalIndex(Object id) {
        String newid;
        DirectoryReader reader;
        block6: {
            reader = null;
            newid = null;
            if (id instanceof ResourceId) {
                newid = id.toString();
            } else if (id instanceof String) {
                newid = (String)id;
            }
            try {
                FSDirectory dir = FSDirectory.open((File)this.stateLocation.toFile());
                if (DirectoryReader.indexExists((Directory)dir)) break block6;
                return false;
            }
            catch (IOException e) {
                log.error("checkFileInGlobalIndex: " + e.toString());
                return true;
            }
        }
        this.globalIndex.commit();
        reader = DirectoryReader.open((IndexWriter)this.globalIndex, (boolean)true);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        String pk = newid.replaceAll("-", "").toLowerCase();
        Term target = new Term("primary_key_id", pk);
        TermQuery query = new TermQuery(target);
        TopDocs topDocs = searcher.search((Query)query, 10);
        reader.close();
        return topDocs.totalHits >= 1;
    }

    @Override
    public boolean deleteFilesFromGlobalIndex(Set<ResourceId> setdocs) {
        for (ResourceId filerid : setdocs) {
            String pkvalue = filerid.toString().replaceAll("-", "").toLowerCase();
            Term target = new Term("primary_key_id", pkvalue);
            try {
                this.globalIndex.deleteDocuments(target);
                this.globalIndex.commit();
                log.debug("File '" + filerid.toString() + "' deleted from the global index");
            }
            catch (CorruptIndexException cie) {
                log.error("deleteFileInGlobalIndex: the index is corrupt: " + cie.toString());
                return false;
            }
            catch (IOException e) {
                log.error("deleteFileInGlobalIndex: error deleting the file from the global index: " + e.toString());
                return false;
            }
        }
        log.info(String.valueOf(this.getNumDocsGlobalIndex()) + " docs stored in the global index");
        return true;
    }

    @Override
    public boolean deleteProjectFromGlobalIndex(ResourceId idproject) {
        Term target = new Term("project_id", idproject.toString());
        try {
            this.globalIndex.deleteDocuments(target);
            this.globalIndex.commit();
            log.info("Documents from Project '" + idproject.toString() + "' deleted from the global index");
            log.info(String.valueOf(this.getNumDocsGlobalIndex()) + " docs stored in the global index");
            return true;
        }
        catch (IOException e) {
            log.error("deleteProjectFromGlobalIndex: error deleting the project from the global index: " + e.toString());
            return false;
        }
    }

    @Override
    public void cleanGlobalIndex() {
        DirectoryReader reader = null;
        log.debug("Cleaning the global index...");
        try {
            reader = DirectoryReader.open((IndexWriter)this.globalIndex, (boolean)true);
            HashSet<ResourceId> tempSet = new HashSet<ResourceId>();
            int i = 0;
            while (i < this.getNumDocsGlobalIndex()) {
                Document doc = reader.document(i);
                String fileid = doc.getField("resource_id").stringValue();
                ResourceId filerid = new ResourceId(fileid);
                IFile aFile = this.ws.getFile(filerid);
                if (aFile == null || !aFile.isAccessible() || !this.ws.containsDocument(filerid)) {
                    tempSet.add(filerid);
                }
                ++i;
            }
            this.deleteFilesFromGlobalIndex(tempSet);
            log.debug("done! ...");
            this.globalIndex.commit();
        }
        catch (IOException e) {
            log.error("cleanGlobalIndex: " + e.toString());
        }
    }

    @Override
    public boolean changeProjectId(ResourceId fileid, ResourceId newprojectid) {
        DirectoryReader reader;
        block3: {
            reader = null;
            try {
                this.globalIndex.commit();
                reader = DirectoryReader.open((IndexWriter)this.globalIndex, (boolean)true);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                String pkvalue = fileid.toString().replaceAll("-", "").toLowerCase();
                Term target = new Term("primary_key_id", pkvalue);
                TermQuery query1 = new TermQuery(target);
                TopDocs td = searcher.search((Query)query1, 1);
                if (td.totalHits != 1) break block3;
                int docId = td.scoreDocs[0].doc;
                Document olddoc = searcher.doc(docId);
                reader.close();
                Document newdoc = olddoc;
                newdoc.removeField("project_id");
                StringField idproject = new StringField("project_id", newprojectid.toString(), Field.Store.YES);
                newdoc.add((IndexableField)idproject);
                this.globalIndex.updateDocument(target, (Iterable)newdoc);
                this.globalIndex.commit();
                log.info("Changed the ProjectID of the document '" + this.getTitle(fileid) + "'");
                return true;
            }
            catch (IOException e) {
                log.error("changeProjectId: " + e.getMessage());
                return false;
            }
        }
        reader.close();
        log.error("changeProjectId: Document '" + this.getTitle(fileid) + "' not found in the global index!");
        return false;
    }

    @Override
    public void changeProjectId(Set<ResourceId> fileids, ResourceId newprojectid) {
        for (ResourceId fileid : fileids) {
            if (!this.checkFileInGlobalIndex(fileid)) continue;
            this.changeProjectId(fileid, newprojectid);
        }
    }

    @Override
    public boolean changeContent(ResourceId fileid, String newcontent) {
        DirectoryReader reader;
        block3: {
            reader = null;
            try {
                this.globalIndex.commit();
                reader = DirectoryReader.open((IndexWriter)this.globalIndex, (boolean)true);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                String pkvalue = fileid.toString().replaceAll("-", "").toLowerCase();
                Term target = new Term("primary_key_id", pkvalue);
                TermQuery query1 = new TermQuery(target);
                TopDocs td = searcher.search((Query)query1, 1);
                if (td.totalHits != 1) break block3;
                int docId = td.scoreDocs[0].doc;
                Document olddoc = searcher.doc(docId);
                reader.close();
                Document newdoc = olddoc;
                newdoc.removeField("content");
                TextField newcontentfield = new TextField("content", newcontent, Field.Store.NO);
                newdoc.add((IndexableField)newcontentfield);
                this.globalIndex.updateDocument(target, (Iterable)newdoc);
                this.globalIndex.commit();
                log.info("Updated the document '" + this.getTitle(fileid) + "' in the global index");
                return true;
            }
            catch (IOException e) {
                log.error("changeContent: " + e.getMessage());
                return false;
            }
        }
        reader.close();
        log.error("changeContent: Document '" + this.getTitle(fileid) + "' not found in the global index!");
        return false;
    }

    @Override
    public int getNumDocsGlobalIndex() {
        return this.globalIndex.numDocs();
    }

    @Override
    public void performSearch(String queryString, int numberToRetrieve) {
        SearchIndexJob searchjob = new SearchIndexJob("Searching local index");
        searchjob.setNumberDocsToRetrieve(numberToRetrieve);
        searchjob.setQueryString(queryString);
        IndexServiceEventImpl indexServiceEvent = new IndexServiceEventImpl("osint/index");
        searchjob.addJobChangeListener((IJobChangeListener)new JobChangeListener(indexServiceEvent));
        searchjob.setUser(true);
        searchjob.schedule();
    }

    @Override
    public void showSearchResults(TopDocs results, IndexSearcher searcher) {
        int i = 0;
        while (i < results.totalHits) {
            ScoreDoc[] hits = results.scoreDocs;
            try {
                Document doc = searcher.doc(hits[i].doc);
                String fileid = doc.get("resource_id");
                log.debug(" - File title: " + this.getTitle(new ResourceId(fileid)));
            }
            catch (IOException e) {
                log.error("Failed to showSearchResults", (Throwable)e);
            }
            ++i;
        }
    }

    @Override
    public String getTitle(ResourceId fileid) {
        CaseProject cp = this.ws.getCaseProjectByDocumentId(fileid);
        DocumentMetaItem dmi = cp.getMetaItem(fileid);
        String title = dmi.getTitle();
        if (title == null || title.length() == 0) {
            return this.ws.getResource(fileid).getName();
        }
        return dmi.getTitle();
    }

    @Override
    public String getType(ResourceId fileid) {
        return this.getPath(fileid).substring(this.getPath(fileid).length() - 3);
    }

    @Override
    public String getPath(ResourceId fileid) {
        CaseProject cp = this.ws.getCaseProjectByDocumentId(fileid);
        IFile file = cp.getFile(fileid);
        return file.getLocation().toOSString();
    }

    @Override
    public String getProjectTitle(ResourceId projectid) {
        CaseProject cp = this.ws.getCaseProjectByDocumentId(projectid);
        return cp.getName();
    }

    @Override
    public void showGlobalIndexStatus() {
        DirectoryReader reader = null;
        log.debug("\n -------- GLOBAL INDEX STATUS -------\n");
        try {
            this.globalIndex.commit();
            FSDirectory dir = FSDirectory.open((File)this.stateLocation.toFile());
            reader = DirectoryReader.open((Directory)dir);
            int i = 0;
            while (i < this.getNumDocsGlobalIndex()) {
                Document doc = reader.document(i);
                String fileid = doc.getField("resource_id").stringValue();
                String title = this.getTitle(new ResourceId(fileid));
                String projectid = doc.getField("project_id").stringValue();
                String project = this.getProjectTitle(new ResourceId(projectid));
                String path = doc.getField("path").stringValue();
                int count = i + 1;
                log.debug(" - " + count + " - " + title + " (" + project + ") - " + fileid + " - --> '" + path + "'");
                ++i;
            }
            log.debug("\n -------- --------------- ---------\n");
        }
        catch (IOException e) {
            log.error("showGlobalIndexStatus: " + e.toString());
        }
    }

    private void fireIndexServiceEvent(IndexServiceEvent event) {
        IndexPlugin.getEventBroker().postEvent((SystemEvent)event);
    }

    private class DisableSearchJob
    extends Job {
        public DisableSearchJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }

    private class JobChangeListener
    extends JobChangeAdapter {
        private IndexServiceEventImpl serviceEvent;

        public JobChangeListener(IndexServiceEventImpl serviceEvent) {
            this.serviceEvent = serviceEvent;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            if (event.getJob().getClass().equals(SearchIndexJob.class)) {
                SearchIndexJob job = (SearchIndexJob)event.getJob();
                this.serviceEvent.setSearchResults(job.getSearchResults());
                log.info("Found " + job.getSearchResults().size() + " documents");
            }
            if (event.getJob().getClass().equals(DisableSearchJob.class)) {
                log.info("Starting the local index updating...");
            }
            if (event.getJob().getClass().equals(RebuildIndexJob.class)) {
                log.info("Local index updated. " + IndexServiceImpl.this.getNumDocsGlobalIndex() + " documents stored");
            }
            IndexServiceImpl.this.fireIndexServiceEvent(this.serviceEvent);
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            WorkspaceServiceEvent wsEvent;
            if (!(event instanceof WorkspaceServiceEvent) && !(event instanceof TextExtractionServiceEvent)) {
                return;
            }
            if ("osint/workspace/resourceMoved".equals(event.getTopic())) {
                wsEvent = (WorkspaceServiceEvent)event;
                IndexServiceImpl.this.changeProjectId(wsEvent.getResourceIds(), wsEvent.getProjectId());
            }
            if ("osint/workspace/resourceDeleted".equals(event.getTopic())) {
                wsEvent = (WorkspaceServiceEvent)event;
                IndexServiceImpl.this.deleteFilesFromGlobalIndex(wsEvent.getResourceIds());
            }
            if ("osint/textExtraction/extractionSuccess".equals(event.getTopic())) {
                TextExtractionServiceEvent tesEvent = (TextExtractionServiceEvent)event;
                Set setrid = tesEvent.getResourceIds();
                HashSet<ResourceId> setnewdocs = new HashSet<ResourceId>();
                for (ResourceId filerid : setrid) {
                    CaseProject cp = IndexServiceImpl.this.ws.getCaseProjectByDocumentId(filerid);
                    DocumentMetaItem dmi = cp.getMetaItem(filerid);
                    if (IndexServiceImpl.this.checkFileInGlobalIndex(filerid)) {
                        IndexServiceImpl.this.changeContent(filerid, dmi.getText());
                        continue;
                    }
                    setnewdocs.add(filerid);
                }
                if (setnewdocs.size() > 0) {
                    IndexServiceImpl.this.addFilesInGlobalIndex(setnewdocs);
                }
            }
        }
    }
}

