/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.console.internal;

import it.jrc.osint.console.Console;
import it.jrc.osint.console.ConsoleEvent;
import it.jrc.osint.console.internal.ConsoleEventImpl;
import it.jrc.osint.operations.ErrorCondition;
import it.jrc.osint.util.DebugUtil;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import java.text.MessageFormat;

public class ConsoleImpl
implements Console {
    private EventBroker eventBroker;

    public ConsoleImpl(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
        if (DebugUtil.inDebugMode()) {
            this.eventBroker.register(new String[]{"osint/*"}, (TopicEventListener)new DebugTopicEventListenerImpl());
        }
    }

    @Override
    public void info(String aMessage) {
        this.eventBroker.postEvent((SystemEvent)new ConsoleEventImpl("osint/console/messageReceived", ConsoleEvent.MessageType.INFO, aMessage));
    }

    @Override
    public void warn(String aMessage) {
        this.eventBroker.postEvent((SystemEvent)new ConsoleEventImpl("osint/console/messageReceived", ConsoleEvent.MessageType.WARN, aMessage));
    }

    @Override
    public void error(String aMessage) {
        this.eventBroker.postEvent((SystemEvent)new ConsoleEventImpl("osint/console/messageReceived", ConsoleEvent.MessageType.ERROR, aMessage));
    }

    @Override
    public void error(String aMessage, Object ... arguments) {
        String formattedMessage = MessageFormat.format(aMessage, arguments);
        this.error(formattedMessage);
    }

    @Override
    public void error(ErrorCondition errorCondition) {
        if (errorCondition == null) {
            return;
        }
        this.error(errorCondition.toString());
    }

    private class DebugTopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private DebugTopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if (!event.getTopic().startsWith("osint/console")) {
                ConsoleImpl.this.info(event.toString());
            }
        }
    }
}

