/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.dialogs;

import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.dialogs.SelectEntityTypesDialog;
import it.jrc.osint.analysis.ui.dialogs.SelectEntityTypesModel;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.EntityType;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;

public class SelectEntityTypesController {
    private SelectEntityTypesModel model;
    private SelectEntityTypesDialog view;

    public SelectEntityTypesController(Set<String> selectedTypes) {
        this.model = new SelectEntityTypesModel(selectedTypes);
    }

    public int openView(Shell parentShell) {
        if (this.view == null) {
            this.view = new SelectEntityTypesDialog(parentShell, this);
        }
        return this.view.open();
    }

    public SelectEntityTypesModel getModel() {
        return this.model;
    }

    boolean isTypeVisible(EntityType aType) {
        return this.model.isSelected(aType.getId());
    }

    void changeVisibleStateOfType(EntityType element, Boolean newState) {
        this.model.setSelection(element.getId(), newState);
        this.view.refreshEntityTypesTable();
    }

    void onViewCreation() {
        ExtractionService es = AnalysisUIPlugin.getExtractionService();
        List availableTypes = es.getEntityTypes();
        availableTypes.remove(EntityType.NULL_TYPE);
        availableTypes.remove(EntityType.UNKNOWN_UNUSED_TYPE);
        this.view.setEntityTypesTableInput(availableTypes);
    }
}

