/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.resources.IFile;

public class DocumentEditorModel {
    public static final String PROP_CHANGED = "changed";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResourceId resourceId;
    private String sourceURL;

    public DocumentEditorModel(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public DocumentEditorModel(ResourceId docId) {
        this.resourceId = docId;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public DocumentMetaItem getDocumentMetaItem() {
        if (this.hasDocument()) {
            WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
            CaseProject cp = ws.getCaseProjectByDocumentId(this.resourceId);
            return cp.getMetaItem(this.resourceId);
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangedListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setResourceId(ResourceId docId) {
        this.resourceId = docId;
        this.propertyChangeSupport.firePropertyChange(PROP_CHANGED, false, true);
    }

    public String getSourceURL() {
        if (this.hasDocument()) {
            DocumentMetaItem metaItem = this.getDocumentMetaItem();
            String link = metaItem.getLink();
            if (link == null || "".equals(link)) {
                WorkspaceService wks = WorkspacePlugin.getWorkspaceService();
                CaseProject cp = wks.getCaseProjectByDocumentId(metaItem.getResourceId());
                IFile file = cp.getFile(this.resourceId);
                return file.getLocationURI().toString();
            }
            return link;
        }
        return this.sourceURL;
    }

    public boolean hasDocument() {
        return this.resourceId != null;
    }
}

