/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.editors.ColorManager;
import it.jrc.osint.analysis.ui.editors.DocumentViewerEditorModel;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotation;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationFilter;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationModel;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.ui.TextStyleRegistry;
import it.jrc.osint.workspace.WorkspaceService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class DocumentHTMLViewer
extends Composite {
    private static final Logger log = LogManager.getLogger((String)DocumentHTMLViewer.class.getName());
    private SourceViewer sourceViewer;
    private OverviewRuler overviewRuler;
    private VerticalRuler verticalRuler;
    private TextStyleRegistry styleRegistry;
    private Set<EntityTextAnnotationFilter> annotationFilterSet = new HashSet<EntityTextAnnotationFilter>();
    private DocumentViewerEditorModel model;

    public DocumentHTMLViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.verticalRuler = new VerticalRuler(10);
        this.overviewRuler = new OverviewRuler((IAnnotationAccess)new DefaultMarkerAnnotationAccess(), 10, (ISharedTextColors)new ColorManager());
        this.sourceViewer = new SourceViewer((Composite)this, (IVerticalRuler)new VerticalRuler(10), (IOverviewRuler)this.overviewRuler, true, 2816);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.getTextWidget().setWordWrap(true);
        this.styleRegistry = AnalysisUIPlugin.getPlugin().getTextStyleRegistry();
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.fillContextMenu((IMenuManager)menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DocumentHTMLViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.sourceViewer.getTextWidget());
        this.sourceViewer.getTextWidget().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        IAction showAllEntitiesTextLocationAction = this.showAllEntitiesTextLocationAction();
        menuMgr.add(showAllEntitiesTextLocationAction);
    }

    private IAction showAllEntitiesTextLocationAction() {
        Action highlightEntityAction = new Action(){

            public void run() {
                try {
                    AnalysisUIPlugin.getEventBroker().postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/resetEntityMarkup"));
                }
                catch (Throwable t) {
                    log.error("Failed to highlight entity");
                }
            }
        };
        highlightEntityAction.setText("Show All Entities Text Locations");
        return highlightEntityAction;
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public boolean setFocus() {
        return this.sourceViewer.getControl().setFocus();
    }

    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.refreshDocumentMarkup(this.model.getResourceId(), true);
        }
        super.setVisible(visible);
    }

    public void setModel(DocumentViewerEditorModel model) {
        this.model = model;
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("changed".equals(evt.getPropertyName())) {
                    DocumentHTMLViewer.this.refreshDocumentMarkup(DocumentHTMLViewer.this.model.getResourceId(), true);
                }
            }
        });
        this.refreshDocumentMarkup(this.model.getResourceId(), true);
    }

    public void refreshDocumentMarkup(ResourceId docId, boolean forceRender) {
        if (docId == null || ResourceId.NULL_ID.equals((Object)docId)) {
            return;
        }
        ExecutorService es = Executors.newSingleThreadExecutor();
        es.execute(new LoadTextAndAnnotationsRunnable(docId, forceRender));
    }

    public void addFilter(EntityTextAnnotationFilter aFilter) {
        this.annotationFilterSet.add(aFilter);
    }

    public void clearFilter() {
        this.annotationFilterSet.clear();
    }

    public void dispose() {
        super.dispose();
    }

    private EntityTextAnnotationModel computeAnnotationModel(DocumentMetaItem metaItem) {
        if (metaItem == null) {
            return EntityTextAnnotationModel.EMPTY_MODEL;
        }
        WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
        String htmlSource = ws.readFile(metaItem.getResourceId());
        if (htmlSource == null) {
            htmlSource = "";
        }
        EntityTextAnnotationModel annotationModel = new EntityTextAnnotationModel(htmlSource.length(), 0);
        annotationModel.setFilterSet(this.annotationFilterSet);
        AnalysisService as = AnalysisUIPlugin.getAnalysisService();
        Set docEntityRelationSet = as.getDocumentEntityRelations(metaItem.getResourceId());
        for (DocumentEntityRelation der : docEntityRelationSet) {
            Entity entity = der.getEntity();
            String source = entity.getField("source", "text");
            if (!"html".equals(source)) continue;
            for (EntityTextPosition etp : der.getTextPositions()) {
                EntityTextAnnotation newAnnotation = new EntityTextAnnotation(der.getEntity(), etp.getPos(), etp.getLength());
                annotationModel.add(newAnnotation);
            }
        }
        return annotationModel;
    }

    private void computeStyleRanges(EntityTextAnnotationModel model, TextPresentation tp) {
        Set<EntityTextAnnotation> annotations = model.getAll();
        int offset = 0;
        for (EntityTextAnnotation annotation : annotations) {
            if (annotation.getCharPos() < offset) continue;
            Color[] color = this.getColorForEntityType(annotation.getType());
            StyleRange sr = new StyleRange(annotation.getCharPos(), annotation.getLength(), color[0], color[1]);
            tp.addStyleRange(sr);
            offset = annotation.getCharPos() + annotation.getLength();
        }
    }

    private Color[] getColorForEntityType(String typeId) {
        Color[] styleColors = this.styleRegistry.getColors(typeId);
        return styleColors;
    }

    private class LoadTextAndAnnotationsRunnable
    implements Runnable {
        private ResourceId docId;
        private boolean forceRender;
        private boolean visible;

        public LoadTextAndAnnotationsRunnable(ResourceId docId, boolean forceRender) {
            this.docId = docId;
            this.forceRender = forceRender;
        }

        @Override
        public void run() {
            try {
                Display.getDefault().syncExec((Runnable)new LoggingRunnable(log){

                    public void runWithLogging() {
                        LoadTextAndAnnotationsRunnable.this.visible = DocumentHTMLViewer.this.isVisible();
                    }
                });
                if (this.visible || this.forceRender) {
                    this.displayText();
                    this.displayAnnotations();
                }
            }
            catch (Throwable t) {
                log.error("Failed to load text annotations", t);
            }
        }

        private void displayText() {
            String documentText = null;
            DocumentMetaItem metaItem = DocumentHTMLViewer.this.model.loadDocumentMetaItem(this.docId);
            ErrorStatusMetaData emd = new ErrorStatusMetaData(metaItem);
            if (emd.hasErrorStatus()) {
                documentText = "EMM OSINT Suite: An error has occurred during processing of this document; Error Message: " + emd.getErrorMessage() + "; " + "Error Code: " + emd.getErrorCode() + " \n" + "We tried to retrieve this document from: " + metaItem.getLink();
            } else {
                WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
                documentText = ws.readFile(this.docId);
            }
            this.setDocumentToWidget(new Document(documentText));
        }

        private void displayAnnotations() {
            DocumentMetaItem metaItem = DocumentHTMLViewer.this.model.loadDocumentMetaItem(this.docId);
            EntityTextAnnotationModel model = DocumentHTMLViewer.this.computeAnnotationModel(metaItem);
            TextPresentation tp = new TextPresentation();
            DocumentHTMLViewer.this.computeStyleRanges(model, tp);
            this.setAnnotationToWidget(tp);
        }

        private void setDocumentToWidget(final Document document) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocumentHTMLViewer.this.sourceViewer.setDocument((IDocument)document);
                }
            });
        }

        private void setAnnotationToWidget(final TextPresentation tp) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocumentHTMLViewer.this.sourceViewer.changeTextPresentation(tp, true);
                }
            });
        }
    }
}

