/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.analysis.ui.AnalysisUIEventImpl;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.editors.DocumentViewerEditorModel;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotation;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationFilter;
import it.jrc.osint.analysis.ui.views.EntityTextAnnotationModel;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.ui.TextStyleRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class DocumentTextViewerNT
extends Composite {
    private static final Logger log = LogManager.getLogger((String)DocumentTextViewerNT.class.getName());
    public static final String ANNO_TYPE_ENTITY = "osint.annotation.type.Entity";
    public static final String ANNO_TYPE_PERSON = "osint.annotation.type.Person";
    public static final String ANNO_KEY_HIGHLIGHT = "annotateElemHighlight";
    public static final String ANNO_KEY_OVERVIEW = "annotateElemOverviewRuler";
    public static final String ANNO_KEY_VERTICAL = "annotateElemVerticalRuler";
    public static final String ANNO_KEY_TEXT = "annotateElemText";
    public static final String ANNO_KEY_COLOR_ENTITY = "annotateElemColorEntity";
    public static final String ANNO_KEY_COLOR_PERSON = "annotateElemColorPerson";
    private IDocument document;
    private AnnotationModel annotationModel;
    private SourceViewer sourceViewer;
    private IAnnotationAccess annotationAccess;
    private VerticalRuler verticalRuler;
    private TextStyleRegistry styleRegistry;
    private Set<EntityTextAnnotationFilter> annotationFilterSet = new HashSet<EntityTextAnnotationFilter>();
    private DocumentViewerEditorModel model;

    public DocumentTextViewerNT(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        int VERTICAL_RULER_WIDTH = 12;
        int styles = 68354;
        ISharedTextColors sharedColors = AnalysisUIPlugin.getPlugin().getSharedTextColors();
        OverviewRuler overviewRuler = new OverviewRuler(null, VERTICAL_RULER_WIDTH, sharedColors);
        CompositeRuler ruler = new CompositeRuler(VERTICAL_RULER_WIDTH);
        this.document = new Document();
        this.document.set("This is a test document");
        this.annotationModel = new AnnotationModel();
        this.annotationModel.connect(this.document);
        this.sourceViewer = new SourceViewer((Composite)this, (IVerticalRuler)ruler, (IOverviewRuler)overviewRuler, true, styles);
        this.sourceViewer.configure(new SourceViewerConfiguration());
        AnalysisUIPlugin.getPlugin().getPreferenceStore().setValue(ANNO_KEY_HIGHLIGHT, true);
        AnalysisUIPlugin.getPlugin().getPreferenceStore().setValue(ANNO_KEY_TEXT, true);
        PreferenceConverter.setValue((IPreferenceStore)AnalysisUIPlugin.getPlugin().getPreferenceStore(), (String)ANNO_KEY_COLOR_ENTITY, (RGB)new RGB(255, 255, 0));
        PreferenceConverter.setValue((IPreferenceStore)AnalysisUIPlugin.getPlugin().getPreferenceStore(), (String)ANNO_KEY_COLOR_PERSON, (RGB)new RGB(0, 255, 0));
        SourceViewerDecorationSupport sourceViewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, (IOverviewRuler)overviewRuler, null, sharedColors);
        AnnotationPreference ap_entity = new AnnotationPreference();
        ap_entity.setColorPreferenceKey(ANNO_KEY_COLOR_ENTITY);
        ap_entity.setHighlightPreferenceKey(ANNO_KEY_HIGHLIGHT);
        ap_entity.setVerticalRulerPreferenceKey(ANNO_KEY_VERTICAL);
        ap_entity.setOverviewRulerPreferenceKey(ANNO_KEY_OVERVIEW);
        ap_entity.setTextPreferenceKey(ANNO_KEY_TEXT);
        ap_entity.setAnnotationType((Object)ANNO_TYPE_ENTITY);
        sourceViewerDecorationSupport.setAnnotationPreference(ap_entity);
        AnnotationPreference ap_person = new AnnotationPreference();
        ap_person.setColorPreferenceKey(ANNO_KEY_COLOR_PERSON);
        ap_person.setHighlightPreferenceKey(ANNO_KEY_HIGHLIGHT);
        ap_person.setVerticalRulerPreferenceKey(ANNO_KEY_VERTICAL);
        ap_person.setOverviewRulerPreferenceKey(ANNO_KEY_OVERVIEW);
        ap_person.setTextPreferenceKey(ANNO_KEY_TEXT);
        ap_person.setAnnotationType((Object)ANNO_TYPE_PERSON);
        sourceViewerDecorationSupport.setAnnotationPreference(ap_person);
        sourceViewerDecorationSupport.install(AnalysisUIPlugin.getPlugin().getPreferenceStore());
        this.sourceViewer.setDocument(this.document, (IAnnotationModel)this.annotationModel);
        this.sourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
        Annotation an_entity = new Annotation(false);
        an_entity.setType(ANNO_TYPE_ENTITY);
        Position position_entity = new Position(0, 4);
        this.annotationModel.addAnnotation(an_entity, position_entity);
        Annotation an_person = new Annotation(false);
        an_person.setType(ANNO_TYPE_PERSON);
        Position position_person = new Position(4, 4);
        this.annotationModel.addAnnotation(an_person, position_person);
        this.styleRegistry = AnalysisUIPlugin.getPlugin().getTextStyleRegistry();
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        this.fillContextMenu((IMenuManager)menuMgr);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DocumentTextViewerNT.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.sourceViewer.getTextWidget());
        this.sourceViewer.getTextWidget().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        IAction showAllEntitiesTextLocationAction = this.showAllEntitiesTextLocationAction();
        menuMgr.add(showAllEntitiesTextLocationAction);
    }

    private IAction showAllEntitiesTextLocationAction() {
        Action highlightEntityAction = new Action(){

            public void run() {
                try {
                    AnalysisUIPlugin.getEventBroker().postEvent((SystemEvent)new AnalysisUIEventImpl("osint/analysis/ui/resetEntityMarkup"));
                }
                catch (Throwable t) {
                    log.error("Failed to highlight entity");
                }
            }
        };
        highlightEntityAction.setText("Show All Entities Text Locations");
        return highlightEntityAction;
    }

    public SourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public boolean setFocus() {
        return this.sourceViewer.getControl().setFocus();
    }

    public void setVisible(boolean visible) {
        if (!this.isVisible() && visible) {
            this.refreshDocumentMarkup(this.model.getResourceId(), true);
        }
        super.setVisible(visible);
    }

    public void setModel(DocumentViewerEditorModel model) {
        this.model = model;
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("changed".equals(evt.getPropertyName())) {
                    DocumentTextViewerNT.this.refreshDocumentMarkup(DocumentTextViewerNT.this.model.getResourceId(), true);
                }
            }
        });
        this.refreshDocumentMarkup(this.model.getResourceId(), true);
    }

    public void refreshDocumentMarkup(ResourceId docId, boolean forceRender) {
        if (docId == null || ResourceId.NULL_ID.equals((Object)docId)) {
            return;
        }
        ExecutorService es = Executors.newSingleThreadExecutor();
        es.execute(new LoadTextAndAnnotationsRunnable(docId, forceRender));
    }

    public void addFilter(EntityTextAnnotationFilter aFilter) {
        this.annotationFilterSet.add(aFilter);
    }

    public void clearFilter() {
        this.annotationFilterSet.clear();
    }

    public void dispose() {
        super.dispose();
    }

    private EntityTextAnnotationModel computeAnnotationModel(DocumentMetaItem metaItem) {
        if (metaItem == null) {
            return EntityTextAnnotationModel.EMPTY_MODEL;
        }
        EntityTextAnnotationModel annotationModel = new EntityTextAnnotationModel(metaItem.getText().length(), metaItem.getTitle().length());
        annotationModel.setFilterSet(this.annotationFilterSet);
        AnalysisService as = AnalysisUIPlugin.getAnalysisService();
        Set docEntityRelationSet = as.getDocumentEntityRelations(metaItem.getResourceId());
        for (DocumentEntityRelation der : docEntityRelationSet) {
            for (EntityTextPosition etp : der.getTextPositions()) {
                EntityTextAnnotation newAnnotation = new EntityTextAnnotation(der.getEntity(), etp.getPos(), etp.getLength());
                annotationModel.add(newAnnotation);
            }
        }
        return annotationModel;
    }

    private void computeStyleRanges(EntityTextAnnotationModel model, TextPresentation tp) {
        Set<EntityTextAnnotation> annotations = model.getAll();
        int offset = 0;
        for (EntityTextAnnotation annotation : annotations) {
            if (annotation.getCharPos() < offset) continue;
            Color[] color = this.getColorForEntityType(annotation.getType());
            StyleRange sr = new StyleRange(annotation.getCharPos(), annotation.getLength(), color[0], color[1]);
            tp.addStyleRange(sr);
            offset = annotation.getCharPos() + annotation.getLength();
        }
    }

    private Color[] getColorForEntityType(String typeId) {
        Color[] styleColors = this.styleRegistry.getColors(typeId);
        return styleColors;
    }

    private class LoadTextAndAnnotationsRunnable
    implements Runnable {
        private ResourceId docId;
        private boolean forceRender;
        private boolean visible;

        public LoadTextAndAnnotationsRunnable(ResourceId docId, boolean forceRender) {
            this.docId = docId;
            this.forceRender = forceRender;
        }

        @Override
        public void run() {
            try {
                Display.getDefault().syncExec((Runnable)new LoggingRunnable(log){

                    public void runWithLogging() {
                        LoadTextAndAnnotationsRunnable.this.visible = DocumentTextViewerNT.this.isVisible();
                    }
                });
                if (!this.visible) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                log.error("Failed to load text annotations", t);
            }
        }

        private void displayText() {
            String documentText = null;
            DocumentMetaItem metaItem = DocumentTextViewerNT.this.model.loadDocumentMetaItem(this.docId);
            ErrorStatusMetaData emd = new ErrorStatusMetaData(metaItem);
            documentText = emd.hasErrorStatus() ? "EMM OSINT Suite: An error has occurred during processing of this document; Error Message: " + emd.getErrorMessage() + "; " + "Error Code: " + emd.getErrorCode() + " \n" + "We tried to retrieve this document from: " + metaItem.getLink() : metaItem.getText();
            Document document = new Document(documentText);
            AnnotationModel annotationModel = new AnnotationModel();
            annotationModel.addAnnotation(new Annotation(DocumentTextViewerNT.ANNO_TYPE_ENTITY, false, "Hello World 1"), new Position(200, 20));
            annotationModel.addAnnotation(new Annotation(DocumentTextViewerNT.ANNO_TYPE_ENTITY, false, "Hello World 2"), new Position(300, 30));
            annotationModel.connect((IDocument)document);
            this.setDocumentToWidget(document, (IAnnotationModel)annotationModel);
        }

        private void displayAnnotations() {
            DocumentMetaItem metaItem = DocumentTextViewerNT.this.model.loadDocumentMetaItem(this.docId);
            EntityTextAnnotationModel model = DocumentTextViewerNT.this.computeAnnotationModel(metaItem);
            TextPresentation tp = new TextPresentation();
            DocumentTextViewerNT.this.computeStyleRanges(model, tp);
            this.setAnnotationToWidget(tp);
        }

        private void setDocumentToWidget(final Document document, final IAnnotationModel annotationModel) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DocumentTextViewerNT.this.sourceViewer.setDocument((IDocument)document, annotationModel);
                }
            });
        }

        private void setAnnotationToWidget(TextPresentation tp) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }
}

