/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.editors;

import it.jrc.osint.analysis.EntityContainer;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.extract.ExtractionService;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DocumentViewerOutlinePage
extends ContentOutlinePage {
    private EntityContainer entityContainer;

    public DocumentViewerOutlinePage(EntityContainer entityContainer) {
        this.entityContainer = entityContainer;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setContentProvider((IContentProvider)new EntityTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new EntityTreeLabelProvider());
        TreeNode contentTreeNode = this.getEntitiesSubTree(this.entityContainer.getEntities());
        if (contentTreeNode != null) {
            treeViewer.setInput((Object)contentTreeNode);
        }
    }

    private TreeNode getEntitiesSubTree(Set<Entity> entitySet) {
        HashMap<String, HashSet<Entity>> entityTypeMap = new HashMap<String, HashSet<Entity>>();
        for (Entity entity : entitySet) {
            if (entity == null) continue;
            String typeId = entity.getType();
            HashSet<Entity> typeEntitySet = (HashSet<Entity>)entityTypeMap.get(typeId);
            if (typeEntitySet == null) {
                typeEntitySet = new HashSet<Entity>();
                entityTypeMap.put(typeId, typeEntitySet);
            }
            typeEntitySet.add(entity);
        }
        TreeNode rootNode = new TreeNode((Object)"Entities");
        LinkedList<TreeNode> typeNodes = new LinkedList<TreeNode>();
        ExtractionService es = AnalysisUIPlugin.getExtractionService();
        List entityTypeList = es.getEntityTypes();
        for (EntityType t : entityTypeList) {
            TreeNode typeNode = new TreeNode((Object)t);
            this.createSubTreeForType(typeNode, (Set)entityTypeMap.get(t), t);
            if (!typeNode.hasChildren()) continue;
            typeNodes.add(typeNode);
        }
        TreeNode[] entityTypeNodes = typeNodes.toArray(new TreeNode[0]);
        if (entityTypeNodes.length == 0) {
            return null;
        }
        rootNode.setChildren(entityTypeNodes);
        return rootNode;
    }

    private void createSubTreeForType(TreeNode parent, Set<Entity> entitySet, EntityType entityType) {
        if (entitySet == null || entitySet.size() == 0) {
            return;
        }
        TreeNode[] childNodes = new TreeNode[entitySet.size()];
        int i = 0;
        for (Entity entity : entitySet) {
            TreeNode newEntityNode = new TreeNode((Object)entity);
            childNodes[i++] = newEntityNode;
        }
        parent.setChildren(childNodes);
    }

    private class EntityTreeContentProvider
    extends TreeNodeContentProvider {
        private EntityTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeNode) {
                return super.getChildren(parentElement);
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof TreeNode) {
                TreeNode input = (TreeNode)inputElement;
                return input.getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeNode) {
                return super.getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeNode) {
                return super.hasChildren(element);
            }
            return false;
        }
    }

    private class EntityTreeLabelProvider
    extends LabelProvider {
        private EntityTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                Object nodeValue = node.getValue();
                if (nodeValue instanceof Entity) {
                    return ((Entity)nodeValue).getName();
                }
                return nodeValue.toString();
            }
            return super.getText(element);
        }
    }
}

