/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.graph;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.graph.ConnectingDocumentsController;
import it.jrc.osint.analysis.ui.graph.ConnectingDocumentsModel;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class ConnectingDocumentsDialog
extends Dialog {
    private static final Logger log = LogManager.getLogger((String)ConnectingDocumentsDialog.class.getName());
    private ConnectingDocumentsController controller;
    private Table documentsTable;
    private TableViewer documentsTableViewer;
    private Button openButton;
    private String title = "";

    ConnectingDocumentsDialog(Shell parentShell) {
        super(parentShell);
    }

    ConnectingDocumentsDialog(Shell parentShell, ConnectingDocumentsController controller) {
        this(parentShell);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblSelectVisibleEntity = new Label(container, 0);
        lblSelectVisibleEntity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSelectVisibleEntity.setText("Select documents to open:");
        Composite typesTableContainer = new Composite(container, 0);
        typesTableContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout columnLayout = new TableColumnLayout();
        typesTableContainer.setLayout((Layout)columnLayout);
        this.documentsTable = new Table(typesTableContainer, 67586);
        this.documentsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)ConnectingDocumentsDialog.this.documentsTableViewer.getSelection();
                HashSet<ResourceId> selectedDocs = new HashSet<ResourceId>();
                selectedDocs.addAll(sel.toList());
                ConnectingDocumentsDialog.this.controller.setSelectedDocs(selectedDocs);
            }
        });
        this.documentsTable.setHeaderVisible(true);
        this.documentsTable.setLinesVisible(true);
        this.documentsTableViewer = new TableViewer(this.documentsTable);
        this.documentsTableViewer.setContentProvider((IContentProvider)new DocumentsContentProvider());
        this.documentsTableViewer.setLabelProvider((IBaseLabelProvider)new DocumentsLabelProvider());
        TableColumn nameColumn = new TableColumn(this.documentsTable, 0);
        nameColumn.setText("Title");
        TableViewerColumn nameColumnViewer = new TableViewerColumn(this.documentsTableViewer, nameColumn);
        nameColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return "";
                }
                if (element instanceof ResourceId) {
                    return ConnectingDocumentsDialog.this.getDocumentLabel((ResourceId)element);
                }
                return "";
            }
        });
        ColumnWeightData nameColumnWeightData = new ColumnWeightData(80);
        nameColumnWeightData.minimumWidth = 150;
        columnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)nameColumnWeightData);
        this.controller.onViewCreation();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.openButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.openButton.setText("Open");
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(495, 388);
    }

    void setModel(ConnectingDocumentsModel model) {
        this.documentsTableViewer.setInput(model.getDocumentIds());
        this.title = "Documents connecting \"" + model.getSourceEntity() + "\" and \"" + model.getDestEntity() + "\"";
        this.getShell().setText(this.title);
    }

    void refreshEntityTypesTable() {
        Display dsp = this.getShell().getDisplay();
        dsp.asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectingDocumentsDialog.this.documentsTableViewer.refresh();
            }
        });
    }

    private String getDocumentLabel(ResourceId resourceId) {
        String label = null;
        WorkspaceService ws = AnalysisUIPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(resourceId);
        DocumentMetaItem metaItem = cp.getMetaItem(resourceId);
        if (metaItem == null) {
            log.error("Connecting document not found");
            return "error: Document not found";
        }
        label = metaItem.getTitle();
        if (label == null || "".equals(label)) {
            RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
            label = rmd.getFileName();
        }
        if (label == null || "".equals(label)) {
            label = resourceId.toString();
        }
        return label;
    }

    public void setOpenButtonEnabled(final boolean enabled) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConnectingDocumentsDialog.this.openButton != null) {
                    ConnectingDocumentsDialog.this.openButton.setEnabled(enabled);
                }
            }
        });
    }

    private class DocumentsContentProvider
    extends StructuredContentProviderAdapter {
        private DocumentsContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof String) {
                return new String[]{(String)input};
            }
            if (input instanceof Set) {
                Set docIds = (Set)input;
                return docIds.toArray();
            }
            return new Object[0];
        }
    }

    private class DocumentsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DocumentsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                switch (columnIndex) {
                    case 0: {
                        return (String)element;
                    }
                    case 1: {
                        return "";
                    }
                }
                return "unknown idx " + columnIndex;
            }
            if (element instanceof ResourceId) {
                switch (columnIndex) {
                    case 0: {
                        return ConnectingDocumentsDialog.this.getDocumentLabel((ResourceId)element);
                    }
                }
                return element.toString();
            }
            return null;
        }
    }
}

