/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.handler;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.graph.GraphView;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddEntityHandler
extends AbstractHandler
implements IHandler {
    private static final Logger log = LogManager.getLogger((String)AddEntityHandler.class.getName());

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow ww = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ww.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    GraphView gv = AddEntityHandler.this.getGraphView(event);
                    if (gv == null) {
                        return;
                    }
                    String entityIdParam = event.getParameter("entityId");
                    if (entityIdParam == null) {
                        log.warn("Failed to retrieve entityId parameter");
                        return;
                    }
                    String projectIdParam = event.getParameter("projectId");
                    if (projectIdParam == null) {
                        log.warn("Failed to retrieve projectId parameter");
                        return;
                    }
                    long entityId = Long.parseLong(entityIdParam);
                    ResourceId projectId = ResourceId.fromString((String)projectIdParam);
                    AnalysisService as = AnalysisUIPlugin.getAnalysisService();
                    AnalysisDatamodel adm = as.getAnalysisDatamodel(projectId, false);
                    if (adm == null || adm.isNull()) {
                        log.warn("Failed to obtain AnalysisDatamodel for project: " + projectId);
                        return;
                    }
                    Entity anEntity = adm.getEntity(entityId);
                    if (anEntity == null) {
                        log.warn("Failed to retrieve entity");
                    }
                    gv.addEntity(anEntity, projectId);
                    return;
                }
                catch (Throwable t) {
                    log.error("Failed to add entity to graph view", t);
                    return;
                }
            }
        });
        return null;
    }

    private GraphView getGraphView(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        GraphView graphView = (GraphView)window.getActivePage().findView("it.jrc.osint.analysis.ui.views.GraphView");
        if (graphView == null) {
            return this.openAndActivateGraphView(event);
        }
        return graphView;
    }

    private GraphView openAndActivateGraphView(ExecutionEvent event) {
        IViewPart graphViewPart = null;
        try {
            graphViewPart = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().showView("it.jrc.osint.analysis.ui.views.GraphView");
            if (graphViewPart != null) {
                HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().activate((IWorkbenchPart)graphViewPart);
            }
        }
        catch (Throwable t) {
            log.error("Failed to open GraphView", t);
        }
        return (GraphView)graphViewPart;
    }
}

