/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.handler;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.AnalysisDatamodel;
import it.jrc.osint.analysis.AnalysisService;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.handler.EntityBrowserHandler;
import it.jrc.osint.analysis.ui.views.EntityBrowserView;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class ShowRelatedEntitiesHandler
extends EntityBrowserHandler {
    private static final Logger log = LogManager.getLogger((String)ShowRelatedEntitiesHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EntityBrowserView ebv = this.getEntityBrowserView(event);
        if (ebv == null) {
            return null;
        }
        String entityIdParam = event.getParameter("entityId");
        if (entityIdParam == null) {
            log.warn("Failed to retrieve entityId parameter");
            return null;
        }
        String projectIdParam = event.getParameter("projectId");
        if (projectIdParam == null) {
            log.warn("Failed to retrieve projectId parameter");
            return null;
        }
        long entityId = Long.parseLong(entityIdParam);
        ResourceId projectId = ResourceId.fromString((String)projectIdParam);
        AnalysisService as = AnalysisUIPlugin.getAnalysisService();
        AnalysisDatamodel adm = as.getAnalysisDatamodel(projectId, false);
        if (adm == null || adm.isNull()) {
            log.warn("Failed to obtain AnalysisDatamodel for project: " + projectId);
            return null;
        }
        Entity anEntity = adm.getEntity(entityId);
        if (anEntity == null) {
            log.warn("Failed to retrieve entity");
        }
        ebv.showRelatedEntities(entityId, projectId);
        return null;
    }
}

