/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.properties;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.metadata.AcquisitionMetaData;
import it.jrc.osint.metadata.ErrorStatusMetaData;
import it.jrc.osint.metadata.GrabberMetaData;
import it.jrc.osint.metadata.SearchMetaData;
import it.jrc.osint.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ResourceIdPropertySource
implements IPropertySource {
    private ResourceId id;
    private DocumentMetaItem dmi;

    public ResourceIdPropertySource(ResourceId id) {
        this.id = id;
    }

    public ResourceIdPropertySource(ResourceId id, DocumentMetaItem item) {
        this(id);
        this.dmi = item;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> descriptors = new ArrayList<TextPropertyDescriptor>();
        descriptors.add(new TextPropertyDescriptor((Object)"id", "Resource Id"));
        descriptors.add(new TextPropertyDescriptor((Object)"path", "File Path"));
        if (this.dmi != null) {
            SearchMetaData smd;
            ErrorStatusMetaData emd;
            GrabberMetaData gmd;
            Date timestamp;
            descriptors.add(new TextPropertyDescriptor((Object)"title", "Title"));
            descriptors.add(new TextPropertyDescriptor((Object)"lang", "Language"));
            AcquisitionMetaData amd = new AcquisitionMetaData(this.dmi);
            if (amd.getSource() != null) {
                descriptors.add(new TextPropertyDescriptor((Object)"source", "Source"));
            }
            if (this.dmi.getLink() != null) {
                descriptors.add(new TextPropertyDescriptor((Object)"rss-link", "URL"));
            }
            if ((timestamp = (gmd = new GrabberMetaData(this.dmi)).getTimeStamp()) != null) {
                descriptors.add(new TextPropertyDescriptor((Object)"timestamp", "Downloaded at"));
            }
            if ((emd = new ErrorStatusMetaData(this.dmi)).hasErrorStatus()) {
                descriptors.add(new TextPropertyDescriptor((Object)"error-msg", "Error Message"));
            }
            if (!(smd = new SearchMetaData(this.dmi)).isNew()) {
                descriptors.add(new TextPropertyDescriptor((Object)"search-engine", "Search Engine"));
                descriptors.add(new TextPropertyDescriptor((Object)"search-query", "Search Query"));
            }
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("id")) {
            return this.id.toString();
        }
        if (id.equals("path")) {
            return AnalysisUIPlugin.getWorkspaceService().getPath(this.id).toString();
        }
        if (this.dmi != null) {
            if (id.equals("title")) {
                return this.dmi.getTitle();
            }
            if (id.equals("rss-link")) {
                return this.dmi.getLink();
            }
            if (id.equals("lang")) {
                return this.dmi.getLanguage();
            }
            if (id.equals("source")) {
                AcquisitionMetaData amd = new AcquisitionMetaData(this.dmi);
                return amd.getSource();
            }
            if (id.equals("timestamp")) {
                GrabberMetaData gmd = new GrabberMetaData(this.dmi);
                return DateUtil.getFormattedTimestamp((Date)gmd.getTimeStamp());
            }
            if (id.equals("error-msg")) {
                ErrorStatusMetaData emd = new ErrorStatusMetaData(this.dmi);
                return emd.getErrorMessage();
            }
            if (id.equals("search-engine")) {
                SearchMetaData smd = new SearchMetaData(this.dmi);
                return smd.getSearchEngine();
            }
            if (id.equals("search-query")) {
                SearchMetaData smd = new SearchMetaData(this.dmi);
                return smd.getSearchQuery();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

