/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.ui.views.EntityBrowserController;
import it.jrc.osint.analysis.ui.views.EntityBrowserModel;
import it.jrc.osint.analysis.ui.views.EntityTreeViewer;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.util.ui.PartListenerAdapter;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import it.jrc.osint.workspace.CaseProject;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class EntityBrowserView
extends ViewPart {
    public static final String ID = "it.jrc.osint.analysis.ui.views.EntityBrowserView";
    private static final Logger log = LogManager.getLogger((String)EntityBrowserView.class.getName());
    private Text entitySearchText;
    private Combo sourceProjectCombo;
    private ComboViewer sourceProjectComboViewer;
    private Combo userActionCombo;
    private ComboViewer userActionComboViewer;
    private TreeViewer resultTreeViewer;
    private Button entitySearchButton;
    private MenuManager menuMgr;
    private EntityTreeViewer entityTreeViewer;
    private EntityBrowserController controller = new EntityBrowserController(this);
    private PartListenerImpl partListener;

    public EntityBrowserView() {
        this.entityTreeViewer = new EntityTreeViewer(this.controller);
    }

    public EntityTreeViewer getEntityTreeViewer() {
        return this.entityTreeViewer;
    }

    public void createPartControl(Composite parent) {
        this.partListener = new PartListenerImpl();
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite searchComposite = new Composite(container, 0);
        searchComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        searchComposite.setLayout((Layout)new GridLayout(3, false));
        Label sourceProjectLabel = new Label(searchComposite, 0);
        GridData gd_sourceProjectLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sourceProjectLabel.horizontalIndent = 5;
        sourceProjectLabel.setLayoutData((Object)gd_sourceProjectLabel);
        sourceProjectLabel.setSize(74, 15);
        sourceProjectLabel.setText("Select Project:");
        this.sourceProjectComboViewer = new ComboViewer(searchComposite, 8);
        this.sourceProjectComboViewer.setContentProvider((IContentProvider)new SourceProjectComboViewerContentProvider());
        this.sourceProjectComboViewer.setLabelProvider((IBaseLabelProvider)new SourceProjectComboViewerLabelProvider());
        this.sourceProjectCombo = this.sourceProjectComboViewer.getCombo();
        this.sourceProjectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sourceProjectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)EntityBrowserView.this.sourceProjectComboViewer.getSelection();
                Object selectedObject = sel.getFirstElement();
                if (selectedObject instanceof CaseProject) {
                    EntityBrowserView.this.controller.selectProject((CaseProject)selectedObject);
                }
            }
        });
        Composite searchResultComposite = new Composite(container, 2048);
        searchResultComposite.setLayout((Layout)new GridLayout(1, false));
        searchResultComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite = new Composite(searchResultComposite, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.entitySearchText = new Text(composite, 2176);
        this.entitySearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.entitySearchText.setSize(522, 21);
        this.entitySearchButton = new Button(composite, 0);
        this.entitySearchButton.setText("Search");
        this.entitySearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityBrowserView.this.controller.performEntitySearch();
            }
        });
        this.entitySearchText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && EntityBrowserView.this.entitySearchButton.isEnabled()) {
                    EntityBrowserView.this.controller.performEntitySearch();
                }
            }
        });
        Composite navigateComposite = new Composite(searchResultComposite, 0);
        navigateComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gl_navigateComposite = new GridLayout(1, false);
        gl_navigateComposite.verticalSpacing = 2;
        gl_navigateComposite.marginWidth = 0;
        navigateComposite.setLayout((Layout)gl_navigateComposite);
        this.userActionComboViewer = new ComboViewer(navigateComposite, 8);
        this.userActionCombo = this.userActionComboViewer.getCombo();
        this.userActionCombo.setToolTipText("Navigate back to list of entities or search result");
        GridData gd_userActionCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_userActionCombo.horizontalIndent = 5;
        this.userActionCombo.setLayoutData((Object)gd_userActionCombo);
        this.userActionComboViewer.setContentProvider((IContentProvider)new UserActionComboViewerContentProvider());
        this.userActionComboViewer.setLabelProvider((IBaseLabelProvider)new UserActionComboViewerLabelProvider());
        this.userActionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)EntityBrowserView.this.userActionComboViewer.getSelection();
                Object selectedObject = sel.getFirstElement();
                if (selectedObject instanceof EntityBrowserModel.NavigationStep) {
                    EntityBrowserView.this.controller.navigateBack((EntityBrowserModel.NavigationStep)selectedObject);
                }
            }
        });
        Composite resultTreeComposite = new Composite(searchResultComposite, 0);
        GridData gd_resultTreeComposite = new GridData(4, 4, true, true, 1, 1);
        gd_resultTreeComposite.horizontalIndent = 5;
        resultTreeComposite.setLayoutData((Object)gd_resultTreeComposite);
        resultTreeComposite.setLayout((Layout)new FillLayout(256));
        this.resultTreeViewer = this.entityTreeViewer.createPartControl(resultTreeComposite, this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.resultTreeViewer);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.controller.onViewCreation();
    }

    public void removeListeners() {
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
    }

    private void createActions() {
    }

    private void initializeToolBar() {
    }

    private void initializeMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EntityBrowserView.this.entityTreeViewer.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.resultTreeViewer.getControl());
        this.resultTreeViewer.getControl().setMenu(menu);
    }

    public void setFocus() {
    }

    public void showRelatedEntities(long anEntity, ResourceId projectId) {
        this.controller.showRelatedEntities(anEntity, projectId);
    }

    public Set<String> getVisibleEntityTypes() {
        return this.controller.getVisibleEntityTypes();
    }

    public void setVisibleEntityTypes(Set<String> visibleTypes) {
        this.controller.setVisibleEntityTypes(visibleTypes);
    }

    public void setOrderByMode(String mode) {
        this.controller.setOrderByMode(mode);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.controller.init(memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.controller.saveState(memento);
    }

    void setSourceProjects(final List<CaseProject> projects) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    EntityBrowserView.this.sourceProjectComboViewer.setInput((Object)projects);
                }
                catch (Throwable t) {
                    log.error("Failed to set list of source projects", t);
                }
            }
        });
    }

    void selectSourceProject(final CaseProject project) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    StructuredSelection sel = null;
                    sel = project == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)project);
                    EntityBrowserView.this.sourceProjectComboViewer.setSelection((ISelection)sel);
                }
                catch (Throwable t) {
                    log.error("Failed to set selected project", t);
                }
            }
        });
    }

    void showProgressMessage(final String msg) {
        if (this.resultTreeViewer == null) {
            return;
        }
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    EntityBrowserView.this.resultTreeViewer.setInput((Object)msg);
                    EntityBrowserView.this.resultTreeViewer.refresh();
                }
                catch (Throwable t) {
                    log.error("Failed to set input to TreeViewer", t);
                }
            }
        });
    }

    void asyncExecInDisplayThread(Runnable runnable) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec(runnable);
    }

    void setSearch(final String searchTerm) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    EntityBrowserView.this.entitySearchText.setText(searchTerm);
                    EntityBrowserView.this.entitySearchText.setSelection(searchTerm.length());
                }
                catch (Throwable t) {
                    log.error("Failed to set search term", t);
                }
            }
        });
    }

    String getSearchTerm() {
        return this.entitySearchText.getText();
    }

    void setUserActionStack(final List<EntityBrowserModel.NavigationStep> entityStack) {
        Display dsp = this.getSite().getShell().getDisplay();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                if (!entityStack.isEmpty()) {
                    EntityBrowserView.this.userActionComboViewer.setInput((Object)entityStack);
                    StructuredSelection sel = new StructuredSelection(entityStack.get(0));
                    EntityBrowserView.this.userActionComboViewer.setSelection((ISelection)sel);
                }
            }
        });
    }

    private class PartListenerImpl
    extends PartListenerAdapter {
        private PartListenerImpl() {
        }

        public void partClosed(IWorkbenchPart part) {
            super.partClosed(part);
            if (EntityBrowserView.this == part) {
                EntityBrowserView.this.controller.onPartClosed();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            super.partDeactivated(part);
            if (EntityBrowserView.this == part) {
                EntityBrowserView.this.controller.onPartDeactivated();
            }
        }

        public void partActivated(IWorkbenchPart part) {
            super.partActivated(part);
            if (EntityBrowserView.this == part) {
                EntityBrowserView.this.controller.onPartActivated();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            super.partBroughtToTop(part);
            if (EntityBrowserView.this == part) {
                EntityBrowserView.this.controller.onPartBroughtToTop();
            }
        }

        public void partOpened(IWorkbenchPart part) {
            super.partOpened(part);
            if (EntityBrowserView.this == part) {
                EntityBrowserView.this.controller.onPartOpened();
            }
        }
    }

    private class SourceProjectComboViewerContentProvider
    extends StructuredContentProviderAdapter {
        private SourceProjectComboViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String) {
                return new String[]{(String)inputElement};
            }
            if (inputElement instanceof List) {
                List projects = (List)inputElement;
                return projects.toArray(new CaseProject[0]);
            }
            return null;
        }
    }

    private class SourceProjectComboViewerLabelProvider
    extends LabelProviderAdapter {
        private SourceProjectComboViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof CaseProject) {
                return ((CaseProject)element).getName();
            }
            return "";
        }
    }

    private class UserActionComboViewerContentProvider
    extends StructuredContentProviderAdapter {
        private UserActionComboViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String) {
                return new String[]{(String)inputElement};
            }
            if (inputElement instanceof List) {
                List actionTrail = (List)inputElement;
                return actionTrail.toArray(new EntityBrowserModel.NavigationStep[0]);
            }
            return null;
        }
    }

    private class UserActionComboViewerLabelProvider
    extends LabelProviderAdapter {
        private UserActionComboViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            if (element instanceof EntityBrowserModel.NavigationStep) {
                return ((EntityBrowserModel.NavigationStep)element).toString();
            }
            return null;
        }
    }
}

