/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.ui.views;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.EntityRelationshipData;
import it.jrc.osint.analysis.ui.AnalysisUIPlugin;
import it.jrc.osint.analysis.ui.views.EntityTreeViewerController;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.extract.entities.EntityType;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.metadata.RepositoryMetaData;
import it.jrc.osint.util.concurrent.LoggingRunnable;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class EntityTreeViewer {
    private static final Logger log = LogManager.getLogger((String)EntityTreeViewer.class.getName());
    public static final String ORDER_BY_OCCURENCE_COUNT = "occurrencesCount";
    public static final String ORDER_BY_ALPHABETIC = "alphabetic";
    public static final String ORDER_BY_RELATED_DOCS_COUNT = "relatedDocsCount";
    private TreeViewer treeViewer;
    private EntityTreeViewerController controller;
    private String orderBy = "occurrencesCount";

    public EntityTreeViewer(EntityTreeViewerController controller) {
        this.controller = controller;
    }

    public TreeViewer createPartControl(Composite parent, IWorkbenchPartSite site) {
        Tree searchResultTree = new Tree(parent, 2816);
        searchResultTree.setHeaderVisible(true);
        searchResultTree.setLinesVisible(true);
        TreeColumnLayout tcl = new TreeColumnLayout();
        parent.setLayout((Layout)tcl);
        this.treeViewer = new TreeViewer(searchResultTree);
        TreeColumn entityColumn = new TreeColumn(searchResultTree, 16384);
        entityColumn.setAlignment(16384);
        entityColumn.setText("Entities");
        entityColumn.setWidth(180);
        tcl.setColumnData((Widget)entityColumn, (ColumnLayoutData)new ColumnWeightData(50, 180));
        TreeColumn entityFrequencyColumn = new TreeColumn(searchResultTree, 131072);
        entityFrequencyColumn.setAlignment(131072);
        entityFrequencyColumn.setText("freq");
        entityFrequencyColumn.setWidth(30);
        entityFrequencyColumn.setToolTipText("Number of occurrences");
        tcl.setColumnData((Widget)entityFrequencyColumn, (ColumnLayoutData)new ColumnWeightData(25, 30));
        TreeColumn docFrequencyColumn = new TreeColumn(searchResultTree, 131072);
        docFrequencyColumn.setAlignment(131072);
        docFrequencyColumn.setText("docs");
        docFrequencyColumn.setWidth(30);
        docFrequencyColumn.setToolTipText("Number of related documents");
        tcl.setColumnData((Widget)docFrequencyColumn, (ColumnLayoutData)new ColumnWeightData(25, 30));
        this.treeViewer.setContentProvider((IContentProvider)new EntityTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EntityTreeLabelProvider());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)EntityTreeViewer.this.treeViewer.getSelection();
                    Object firstElement = selection.getFirstElement();
                    if (firstElement == null || !(firstElement instanceof TreeNode)) {
                        return;
                    }
                    TreeNode node = (TreeNode)selection.getFirstElement();
                    Object nodeValue = node.getValue();
                    if (nodeValue instanceof ResourceId) {
                        ResourceId resourceId = (ResourceId)nodeValue;
                        EntityTreeViewer.this.controller.openDocument(resourceId);
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to open document view", t);
                }
            }
        });
        return this.treeViewer;
    }

    public void fillContextMenu(IMenuManager manager) {
        Object firstSelectedObject;
        IStructuredSelection ss = (IStructuredSelection)this.treeViewer.getSelection();
        if (ss == null || ss.isEmpty()) {
            return;
        }
        boolean multiSelection = false;
        if (ss.size() > 1) {
            multiSelection = true;
        }
        if ((firstSelectedObject = ss.getFirstElement()) instanceof TreeNode) {
            TreeNode tn = (TreeNode)firstSelectedObject;
            if (tn.getValue() instanceof Entity) {
                Set<Entity> entities = this.obtainEntitiesFromSelection(ss);
                IAction addToGraphAction = this.addToGraphAction(entities);
                manager.add(addToGraphAction);
                if (!multiSelection && this.controller.isShowRelatedEntitiesEnabled()) {
                    IAction navigateToRelatedEntitiesAction = this.navigateToRelatedEntitiesAction(tn);
                    manager.add(navigateToRelatedEntitiesAction);
                }
            }
            if (tn.getValue() instanceof ResourceId) {
                IAction openDocumentAction = this.openDocumentAction(tn);
                manager.add(openDocumentAction);
            }
        }
    }

    public void setOrderByMode(String newMode) {
        this.orderBy = newMode;
    }

    private Set<Entity> obtainEntitiesFromSelection(IStructuredSelection ss) {
        HashSet<Entity> selectedEntities = new HashSet<Entity>();
        for (Object selObject : ss) {
            TreeNode selTN;
            if (!(selObject instanceof TreeNode) || !((selTN = (TreeNode)selObject).getValue() instanceof Entity)) continue;
            selectedEntities.add((Entity)selTN.getValue());
        }
        return selectedEntities;
    }

    public TreeNode computeEntitiesTree(Set<Entity> entities, Set<String> visibleEntityTypes, EntityRelationshipData erd) {
        TreeNode rootNode = new TreeNode((Object)"Entities");
        TreeNode[] entityTypeNodes = this.computeEntityTypeNodes(entities, visibleEntityTypes, erd);
        if (entityTypeNodes != null && entityTypeNodes.length > 0) {
            rootNode.setChildren(entityTypeNodes);
        }
        return rootNode;
    }

    private TreeNode[] computeEntityTypeNodes(Set<Entity> entities, Set<String> visibleEntityTypes, EntityRelationshipData erd) {
        HashMap entityTypeMap = new HashMap();
        for (Entity entity : entities) {
            if (!visibleEntityTypes.contains(entity.getType())) continue;
            EntityNode newEntityNode = new EntityNode(entity);
            newEntityNode.setOccurrenceCount(erd.getEntityOccurrenceCount(entity));
            newEntityNode.setRelatedDocsCount(erd.getRelatedDocsCount(entity));
            if (entityTypeMap.containsKey(entity.getType())) {
                ((Set)entityTypeMap.get(entity.getType())).add(newEntityNode);
                continue;
            }
            HashSet<EntityNode> nodeSet = new HashSet<EntityNode>();
            nodeSet.add(newEntityNode);
            entityTypeMap.put(entity.getType(), nodeSet);
        }
        Set<EntityType> entityTypes = this.controller.getEntityTypes();
        HashSet<EntityTypeNode> entityTypeNodes = new HashSet<EntityTypeNode>();
        for (EntityType entityType : entityTypes) {
            if (!entityTypeMap.containsKey(entityType.getId())) continue;
            EntityTypeNode etn = new EntityTypeNode(entityType);
            Set typeNodes = (Set)entityTypeMap.get(entityType.getId());
            TreeNode[] typeNodesArray = typeNodes.toArray(new EntityNode[typeNodes.size()]);
            Arrays.sort(typeNodesArray, this.getEntityNodeComparator());
            etn.setChildren(typeNodesArray);
            entityTypeNodes.add(etn);
        }
        return entityTypeNodes.toArray(new TreeNode[entityTypeNodes.size()]);
    }

    public TreeNode computeRelatedEntitiesTree(Entity rootEntity, Set<Entity> relatedEntities, Set<String> visibleEntityTypes, EntityRelationshipData erd) {
        TreeNode rootNode = new TreeNode((Object)"Entities");
        TreeNode[] entityTypeNodes = this.computeRelatedEntityTypeNodes(rootEntity, relatedEntities, visibleEntityTypes, erd);
        if (entityTypeNodes != null && entityTypeNodes.length > 0) {
            rootNode.setChildren(entityTypeNodes);
        }
        return rootNode;
    }

    private TreeNode[] computeRelatedEntityTypeNodes(Entity rootEntity, Set<Entity> entities, Set<String> visibleEntityTypes, EntityRelationshipData erd) {
        HashMap entityTypeMap = new HashMap();
        for (Entity entity : entities) {
            if (!visibleEntityTypes.contains(entity.getType())) continue;
            EntityNode newEntityNode = new EntityNode(entity);
            newEntityNode.setOccurrenceCount(erd.getCooccurrenceCount(rootEntity, entity));
            newEntityNode.setRelatedDocsCount(erd.getCooccurrenceDocsCount(rootEntity, entity));
            if (entityTypeMap.containsKey(entity.getType())) {
                ((Set)entityTypeMap.get(entity.getType())).add(newEntityNode);
                continue;
            }
            HashSet<EntityNode> nodeSet = new HashSet<EntityNode>();
            nodeSet.add(newEntityNode);
            entityTypeMap.put(entity.getType(), nodeSet);
        }
        Set<EntityType> entityTypes = this.controller.getEntityTypes();
        HashSet<EntityTypeNode> entityTypeNodes = new HashSet<EntityTypeNode>();
        for (EntityType entityType : entityTypes) {
            if (!entityTypeMap.containsKey(entityType.getId())) continue;
            EntityTypeNode etn = new EntityTypeNode(entityType);
            Set typeNodes = (Set)entityTypeMap.get(entityType.getId());
            TreeNode[] typeNodesArray = typeNodes.toArray(new EntityNode[typeNodes.size()]);
            Arrays.sort(typeNodesArray, this.getEntityNodeComparator());
            etn.setChildren(typeNodesArray);
            entityTypeNodes.add(etn);
        }
        return entityTypeNodes.toArray(new TreeNode[entityTypeNodes.size()]);
    }

    private DocumentNode[] getDocumentNodes(Entity anEntity) {
        Set<ResourceId> documentSet = this.controller.getRelatedDocuments(anEntity);
        DocumentNode[] docNodes = new DocumentNode[documentSet.size()];
        int i = 0;
        for (ResourceId docId : documentSet) {
            DocumentNode newDocNode = new DocumentNode(docId);
            newDocNode.setEntityOccurrences(this.controller.getEntityOccurrences(anEntity, docId));
            docNodes[i++] = newDocNode;
        }
        Arrays.sort(docNodes, this.getDocumentNodeComparator());
        return docNodes;
    }

    public void setInput(final TreeNode rootNode) {
        if (this.treeViewer == null) {
            return;
        }
        Display dsp = Display.getDefault();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    if (!EntityTreeViewer.this.treeViewer.getTree().isDisposed()) {
                        EntityTreeViewer.this.treeViewer.setInput((Object)rootNode);
                        EntityTreeViewer.this.treeViewer.refresh();
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to set input to TreeViewer", t);
                }
            }
        });
    }

    public void clear() {
        if (this.treeViewer == null) {
            return;
        }
        Display dsp = Display.getDefault();
        dsp.asyncExec((Runnable)new LoggingRunnable(log){

            public void runWithLogging() {
                try {
                    if (!EntityTreeViewer.this.treeViewer.getTree().isDisposed()) {
                        EntityTreeViewer.this.treeViewer.setInput(null);
                        EntityTreeViewer.this.treeViewer.refresh();
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to clear TreeViewer", t);
                }
            }
        });
    }

    private String getDocumentLabel(ResourceId resourceId) {
        String label = null;
        WorkspaceService ws = this.controller.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(resourceId);
        if (cp == null) {
            return "";
        }
        DocumentMetaItem metaItem = cp.getMetaItem(resourceId);
        if (metaItem != null) {
            label = metaItem.getTitle();
        }
        if (label == null || "".equals(label)) {
            RepositoryMetaData rmd = new RepositoryMetaData(metaItem);
            label = rmd.getFileName();
        }
        if (label == null || "".equals(label)) {
            label = metaItem.getResourceId().toString();
        }
        return label;
    }

    private IAction navigateToRelatedEntitiesAction(final TreeNode selectedNode) {
        Action navigateToRelatedEntitiesAction = new Action(){

            public void run() {
                if (selectedNode.getValue() instanceof Entity) {
                    Entity entity = (Entity)selectedNode.getValue();
                    EntityTreeViewer.this.controller.showRelatedEntities(entity);
                }
            }
        };
        navigateToRelatedEntitiesAction.setText("Show Related Entities");
        return navigateToRelatedEntitiesAction;
    }

    private IAction addToGraphAction(final Set<Entity> selectedEntities) {
        Action addToGraphAction = new Action(){

            public void run() {
                EntityTreeViewer.this.controller.addEntitiesToGraph(selectedEntities);
            }
        };
        addToGraphAction.setText("Add to Graph");
        return addToGraphAction;
    }

    private IAction openDocumentAction(final TreeNode selectedNode) {
        Action openDocumentAction = new Action(){

            public void run() {
                try {
                    Object nodeValue = selectedNode.getValue();
                    if (nodeValue instanceof ResourceId) {
                        ResourceId resourceId = (ResourceId)nodeValue;
                        EntityTreeViewer.this.controller.openDocument(resourceId);
                    }
                }
                catch (Throwable t) {
                    log.error("Failed to open document");
                }
            }
        };
        openDocumentAction.setText("Open Document");
        return openDocumentAction;
    }

    private Comparator<EntityNode> getEntityNodeComparator() {
        if (this.orderBy.equals(ORDER_BY_OCCURENCE_COUNT)) {
            return Collections.reverseOrder(new EntityNodeComparator());
        }
        if (this.orderBy.equals(ORDER_BY_RELATED_DOCS_COUNT)) {
            return Collections.reverseOrder(new EntityNodeComparator());
        }
        return new EntityNodeComparator();
    }

    private Comparator<DocumentNode> getDocumentNodeComparator() {
        if (this.orderBy.equals(ORDER_BY_OCCURENCE_COUNT)) {
            return Collections.reverseOrder(new DocumentNodeComparator());
        }
        return new DocumentNodeComparator();
    }

    private class DocumentNode
    extends TreeNode
    implements VisibleDomainNode {
        private int entityOccurrences;

        public DocumentNode(ResourceId docId) {
            super((Object)docId);
        }

        public boolean hasChildren() {
            return false;
        }

        public ResourceId getId() {
            return (ResourceId)this.getValue();
        }

        @Override
        public String getText() {
            return EntityTreeViewer.this.getDocumentLabel(this.getId());
        }

        @Override
        public Image getImage() {
            return AnalysisUIPlugin.getPlugin().getImageRegistry().get("document");
        }

        public void setEntityOccurrences(int occurrences) {
            this.entityOccurrences = occurrences;
        }

        public int getEntityOccurrences() {
            return this.entityOccurrences;
        }
    }

    private class DocumentNodeComparator
    implements Comparator<DocumentNode> {
        private DocumentNodeComparator() {
        }

        @Override
        public int compare(DocumentNode n1, DocumentNode n2) {
            if (EntityTreeViewer.this.orderBy.equals(EntityTreeViewer.ORDER_BY_OCCURENCE_COUNT)) {
                return this.compareFrequency(n1, n2);
            }
            return this.compareAlphabetic(n1, n2);
        }

        private int compareAlphabetic(DocumentNode n1, DocumentNode n2) {
            ResourceId id1 = n1.getId();
            ResourceId id2 = n2.getId();
            return EntityTreeViewer.this.getDocumentLabel(id1).compareTo(EntityTreeViewer.this.getDocumentLabel(id2));
        }

        private int compareFrequency(DocumentNode n1, DocumentNode n2) {
            return Integer.compare(n1.getEntityOccurrences(), n2.getEntityOccurrences());
        }
    }

    private class EntityNode
    extends TreeNode
    implements VisibleDomainNode {
        private boolean childrenLoaded;
        private int occurrenceCount;
        private int relatedDocsCount;

        public EntityNode(Entity entity) {
            super((Object)entity);
            this.childrenLoaded = false;
        }

        public boolean hasChildren() {
            return true;
        }

        public TreeNode[] getChildren() {
            if (!this.childrenLoaded) {
                this.loadChildren();
            }
            return super.getChildren();
        }

        public Entity getEntity() {
            return (Entity)this.getValue();
        }

        private void loadChildren() {
            this.setChildren(EntityTreeViewer.this.getDocumentNodes(this.getEntity()));
            this.childrenLoaded = true;
        }

        public String toString() {
            return this.getEntity().getName();
        }

        @Override
        public String getText() {
            return this.toString();
        }

        @Override
        public Image getImage() {
            return AnalysisUIPlugin.getPlugin().getImageForEntityTypeId(this.getEntity().getType());
        }

        public int getOccurrenceCount() {
            return this.occurrenceCount;
        }

        public void setOccurrenceCount(int count) {
            this.occurrenceCount = count;
        }

        public int getRelatedDocsCount() {
            return this.relatedDocsCount;
        }

        public void setRelatedDocsCount(int count) {
            this.relatedDocsCount = count;
        }

        public int hashCode() {
            return this.getEntity().hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof EntityNode) {
                EntityNode otherNode = (EntityNode)other;
                return otherNode.getEntity().equals((Object)this.getEntity());
            }
            return false;
        }
    }

    private class EntityNodeComparator
    implements Comparator<EntityNode> {
        private EntityNodeComparator() {
        }

        @Override
        public int compare(EntityNode n1, EntityNode n2) {
            if (EntityTreeViewer.this.orderBy.equals(EntityTreeViewer.ORDER_BY_ALPHABETIC)) {
                return this.compareAlphabetic(n1, n2);
            }
            if (EntityTreeViewer.this.orderBy.equals(EntityTreeViewer.ORDER_BY_RELATED_DOCS_COUNT)) {
                return this.compareRelatedDocsCount(n1, n2);
            }
            return this.compareEntityOccurrences(n1, n2);
        }

        private int compareAlphabetic(EntityNode n1, EntityNode n2) {
            Entity e1 = n1.getEntity();
            Entity e2 = n2.getEntity();
            return e1.getName().compareTo(e2.getName());
        }

        private int compareEntityOccurrences(EntityNode n1, EntityNode n2) {
            Integer f1 = n1.getOccurrenceCount();
            return f1.compareTo(n2.getOccurrenceCount());
        }

        private int compareRelatedDocsCount(EntityNode n1, EntityNode n2) {
            Integer f1 = n1.getRelatedDocsCount();
            return f1.compareTo(n2.getRelatedDocsCount());
        }
    }

    private class EntityTreeContentProvider
    extends TreeNodeContentProvider {
        private EntityTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeNode) {
                return super.getChildren(parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeNode) {
                return super.getParent(element);
            }
            return false;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreeNode) {
                return super.hasChildren(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            TreeNode input;
            if (inputElement instanceof TreeNode && (input = (TreeNode)inputElement).hasChildren()) {
                return input.getChildren();
            }
            if (inputElement instanceof String) {
                return new String[]{(String)inputElement};
            }
            return new Object[0];
        }
    }

    private class EntityTreeLabelProvider
    implements ITableLabelProvider {
        private EntityTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof VisibleDomainNode) {
                        VisibleDomainNode node = (VisibleDomainNode)element;
                        return node.getText();
                    }
                    if (!(element instanceof String)) break;
                    return (String)element;
                }
                case 1: {
                    if (element instanceof EntityNode) {
                        EntityNode entityNode = (EntityNode)element;
                        return Integer.toString(entityNode.getOccurrenceCount());
                    }
                    if (element instanceof DocumentNode) {
                        DocumentNode docNode = (DocumentNode)element;
                        int occurrences = docNode.getEntityOccurrences();
                        return Integer.toString(occurrences);
                    }
                    return "";
                }
                case 2: {
                    if (element instanceof EntityNode) {
                        EntityNode entityNode = (EntityNode)element;
                        return Integer.toString(entityNode.getRelatedDocsCount());
                    }
                }
                default: {
                    return "";
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    try {
                        if (element instanceof VisibleDomainNode) {
                            VisibleDomainNode node = (VisibleDomainNode)element;
                            return node.getImage();
                        }
                    }
                    catch (Throwable t) {
                        log.error("Problem in EntityTreeLabelProvider", t);
                    }
                    return null;
                }
                case 1: {
                    return null;
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class EntityTypeNode
    extends TreeNode
    implements VisibleDomainNode {
        public EntityTypeNode(EntityType type) {
            super((Object)type);
        }

        public String toString() {
            return this.getValue().toString();
        }

        public EntityType getEntityType() {
            return (EntityType)this.getValue();
        }

        @Override
        public String getText() {
            return this.toString();
        }

        @Override
        public Image getImage() {
            String typeId = this.getEntityType().getId();
            return AnalysisUIPlugin.getPlugin().getImageForEntityTypeId(typeId);
        }
    }

    static interface VisibleDomainNode {
        public String getText();

        public Image getImage();
    }
}

