/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Components {
    private String[] components;

    public int getNumberComponents() {
        return this.components != null ? this.components.length : 0;
    }

    public void setComponents(ArrayList<String> a) {
        int len = a.size();
        this.components = new String[len];
        for (int i = 0; i < len; ++i) {
            this.components[i] = new String(a.get(i));
        }
    }

    public String getComponent(int i) {
        if (this.components == null) {
            return null;
        }
        return i >= 0 && i < this.components.length ? this.components[i] : null;
    }

    public Components() {
        this.components = null;
    }

    public Components(Components f) {
        int len = f.getNumberComponents();
        this.components = new String[len];
        for (int i = 0; i < len; ++i) {
            this.components[i] = f.components[i] != null ? new String(f.components[i]) : null;
        }
    }

    public boolean writeToStream(DataOutputStream d) throws IOException {
        if (this.components == null) {
            return false;
        }
        int len = this.components.length;
        d.writeInt(len);
        for (int i = 0; i < len; ++i) {
            d.writeInt(this.components[i].length());
            d.writeChars(this.components[i]);
        }
        return true;
    }

    public boolean readFromStream(DataInputStream d) throws IOException {
        int len = d.readInt();
        this.components = new String[len];
        for (int i = 0; i < len; ++i) {
            int typeLen = d.readInt();
            char[] temp = new char[typeLen];
            for (int k = 0; k < typeLen; ++k) {
                temp[k] = d.readChar();
            }
            this.components[i] = new String(temp);
        }
        return true;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        int len = this.components.length;
        out.append("Components = [");
        for (int i = 0; i < len; ++i) {
            out.append(this.components[i]);
            if (i >= len - 1) continue;
            out.append(",");
        }
        out.append("]");
        return out.toString();
    }
}

