/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureDisjunction;

public class InputFSDArrayList {
    private transient InputFeatureStructureDisjunction[] elementData;
    private int size;
    private int minCapacity;

    public InputFSDArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new InputFeatureStructureDisjunction[initialCapacity];
    }

    public InputFSDArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            InputFeatureStructureDisjunction[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new InputFeatureStructureDisjunction[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public InputFeatureStructureDisjunction get(int index) {
        return this.elementData[index];
    }

    public void set(int index, InputFeatureStructureDisjunction value) {
        this.elementData[index] = new InputFeatureStructureDisjunction(value);
    }

    public boolean add(InputFeatureStructureDisjunction o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            InputFeatureStructureDisjunction[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new InputFeatureStructureDisjunction[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean add(InputFSDArrayList o) {
        int numElements = o.size();
        for (int i = 0; i < numElements; ++i) {
            this.add(o.get(i));
        }
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public InputFeatureStructureDisjunction removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public InputFeatureStructureDisjunction remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        InputFeatureStructureDisjunction temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }

    public InputFSArrayList convertToFlatList() {
        int len = this.size();
        InputFSArrayList newInputList = new InputFSArrayList(len);
        for (int i = 0; i < len; ++i) {
            InputFeatureStructureDisjunction currentDisj = this.get(i);
            int numFs = currentDisj.getLen();
            for (int j = 0; j < numFs; ++j) {
                InputFeatureStructure next = currentDisj.getFeatureStructure(j);
                newInputList.add(next);
            }
        }
        return newInputList;
    }

    public static InputFSDArrayList createFromSortedInputFSArrayList(InputFSArrayList inputList) {
        if (inputList == null) {
            return null;
        }
        InputFSDArrayList myList = new InputFSDArrayList();
        int size = inputList.size();
        if (size > 0) {
            InputFSArrayList tempFSList = new InputFSArrayList();
            int firstStart = inputList.get(0).getStart();
            tempFSList.add(inputList.get(0));
            for (int currentID = 1; currentID < size; ++currentID) {
                InputFeatureStructure currentFS = inputList.get(currentID);
                int currentStart = currentFS.getStart();
                if (currentStart > firstStart) {
                    myList.add(InputFeatureStructureDisjunction.createNewInputFSD(tempFSList));
                    tempFSList.clear();
                    firstStart = currentStart;
                }
                tempFSList.add(currentFS);
            }
            if (tempFSList.size() > 0) {
                myList.add(InputFeatureStructureDisjunction.createNewInputFSD(tempFSList));
            }
        }
        return myList;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("InputFeatureStructureDisjunctions:");
        out.append('\n');
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            out.append(this.get(i).toString());
        }
        out.append('\n');
        return out.toString();
    }
}

