/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.booleanOperator;

import it.jrc.lt.regexpfs.booleanOperator.BooleanOperator;
import piskorski.util.language.ISO2CountryCode;
import piskorski.util.strings.StringFunctions;

public class ValidVAT
extends BooleanOperator {
    @Override
    public String getName() {
        return "ValidVAT";
    }

    @Override
    public boolean computeValue(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length != 2) {
            return false;
        }
        String country = args[0];
        String number = args[1];
        if (country == null || number == null) {
            return false;
        }
        int len = number.length();
        if (len < 2) {
            return false;
        }
        ISO2CountryCode myCountry = ISO2CountryCode.getCountryCode((String)country);
        if (myCountry == null) {
            if (country.compareTo("EL") == 0) {
                myCountry = ISO2CountryCode.GREECE;
            }
            return false;
        }
        switch (myCountry) {
            case AUSTRIA: {
                if (len != 9) break;
                if (number.charAt(0) != 'U') {
                    return false;
                }
                return StringFunctions.onlyLatinDigits((String)number.substring(1));
            }
            case BELGIUM: {
                if (len != 10 || number.charAt(0) != '0' && number.charAt(0) != '1') break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case BULGARIA: {
                if (len != 8 && len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case CROATIA: {
                if (len != 11) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case CYPRUS: {
                if (len != 9 || !StringFunctions.isUpperCaseLatin((char)number.charAt(8))) break;
                return StringFunctions.onlyLatinDigits((String)number.substring(0, 8));
            }
            case CZECH_REPUBLIC: {
                if (len < 8 || len > 10) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case DENMARK: {
                if (len != 8) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case ESTONIA: {
                if (len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case FINLAND: {
                if (len != 8) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case FRANCE: {
                if (len != 11) break;
                return StringFunctions.onlyLatinDigits((String)number.substring(2));
            }
            case GERMANY: {
                if (len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case GREECE: {
                if (len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case HUNGARY: {
                if (len != 8) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case IRELAND: {
                if (len != 8 && len != 9 || !StringFunctions.onlyLatinDigits((String)number.substring(0, 7)) || !StringFunctions.isUpperCaseLatin((char)number.charAt(7))) break;
                if (len == 9) {
                    return StringFunctions.isUpperCaseLatin((char)number.charAt(8));
                }
                return true;
            }
            case ITALY: {
                if (len != 11) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case LATVIA: {
                if (len != 11) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case LITHUANIA: {
                if (len != 9 && len != 12) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case LUXEMBOURG: {
                if (len != 8) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case MALTA: {
                if (len == 8) {
                    return StringFunctions.onlyLatinDigits((String)number);
                }
            }
            case NETHERLANDS: {
                if (len != 12 || number.charAt(9) != 'B' || !StringFunctions.onlyLatinDigits((String)number.substring(10))) break;
                return StringFunctions.onlyLatinDigits((String)number.substring(0, 9));
            }
            case POLAND: {
                if (len != 10) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case PORTUGAL: {
                if (len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case ROMANIA: {
                if (len < 2 && len > 10) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case SLOVAKIA: {
                if (len != 10 || !StringFunctions.onlyLatinDigits((String)number)) break;
                int num = Integer.valueOf(number);
                return num % 11 == 0;
            }
            case SLOVENIA: {
                if (len != 8) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case SPAIN: {
                if (len != 9) break;
                return StringFunctions.onlyLatinDigits((String)number.substring(1, 8));
            }
            case SWEDEN: {
                if (len != 12) break;
                return StringFunctions.onlyLatinDigits((String)number);
            }
            case UNITED_KINGDOM: {
                if (len == 9 || len == 12) {
                    return StringFunctions.onlyLatinDigits((String)number);
                }
                if (len != 5) break;
                String extraCode = number.substring(0, 2);
                if (extraCode.compareTo("GD") == 0) {
                    return StringFunctions.onlyLatinDigits((String)number.substring(2));
                }
                if (extraCode.compareTo("HA") != 0) break;
                return StringFunctions.onlyLatinDigits((String)number.substring(2));
            }
        }
        return false;
    }
}

