/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.funop;

import it.jrc.lt.regexpfs.funop.FunctionalOperator;
import it.jrc.lt.regexpfs.module.ProcessingException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PLSurnameLemmatize
extends FunctionalOperator {
    private static HashMap<String, String> mySuffixPatterns;

    public PLSurnameLemmatize() throws ProcessingException {
        PLSurnameLemmatize.instantiatePatterns();
    }

    @Override
    public String getName() {
        return "PLSurnameLemmatize";
    }

    private static void instantiatePatterns() throws ProcessingException {
        try {
            URL pURL = FunctionalOperator.class.getResource("resources/PL_surnames_suffixes");
            if (pURL != null) {
                String st;
                mySuffixPatterns = new HashMap();
                BufferedReader in = new BufferedReader(new InputStreamReader(pURL.openStream(), "UTF-8"));
                while ((st = in.readLine()) != null) {
                    StringTokenizer stTok = new StringTokenizer(st, "\t ");
                    String first = stTok.nextToken();
                    String second = stTok.nextToken();
                    mySuffixPatterns.put(first, second);
                }
                in.close();
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Could not read patterns from URL");
        }
    }

    @Override
    public String computeValue(String[] args) {
        if (args.length != 2) {
            return "";
        }
        String surface = args[0];
        String base = args[1];
        if (base != null && base.length() > 0) {
            return base;
        }
        int len = surface.length();
        int sufInd = len - 7;
        if (sufInd < 2) {
            sufInd = 2;
        }
        int maxInd = len - 2;
        while (sufInd < maxInd) {
            String newSuffix = mySuffixPatterns.get(surface.substring(sufInd));
            if (newSuffix != null) {
                return surface.substring(0, sufInd) + newSuffix;
            }
            ++sufInd;
        }
        return surface;
    }
}

