/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.scanner.AbstractScanner;
import it.jrc.lt.core.component.scanner.AbstractScannerItem;
import it.jrc.lt.core.component.scanner.BasicScanner;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class CorleoneBasicScanner
extends Module {
    private static final short LETTER = 0;
    private static final short DIGIT = 1;
    private static final short SYM = 2;
    private static final short SEPARATOR = 3;
    private static final short OTHER = 4;
    private static final short ATTR_TYPE = 0;
    private static final short ATTR_SUBTYPE = 1;
    private static final short ATTR_SURFACE = 2;
    private static String[] scannerTypes = new String[]{"letter", "digit", "sym", "separator", "other"};
    private static String[][] scannerAttrributes = new String[][]{{"TYPE", "SUBTYPE", "SURFACE"}, {"TYPE", "SUBTYPE", "SURFACE"}, {"TYPE", "SUBTYPE", "SURFACE"}, {"TYPE", "SUBTYPE", "SURFACE"}, {"TYPE", "SUBTYPE", "SURFACE"}};
    private static ArrayList<String> scannerTypesList = new ArrayList();
    private static HashMap<String, ArrayList<String>> scannerAttributeLists = new HashMap();
    private AbstractScanner scanner = AbstractScanner.createInstance((String)"basicScanner");
    private static short[] mapType;

    protected CorleoneBasicScanner() {
    }

    @Override
    protected ArrayList<String> getTypes() {
        return scannerTypesList;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return scannerAttributeLists.get(type);
    }

    @Override
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        String ScannerFile = myProperties.getProperty("ResourceFile");
        if (ScannerFile == null) {
            Module.loggerMessage("Missing property: \"" + ScannerFile + "\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        boolean status = this.scanner.readFromFile(ScannerFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + ScannerFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        int len = this.getNumberTypes();
        return this.scanner.applySettings(myConfig);
    }

    @Override
    protected Object performTask(char[] text, ResultPool myResult) throws ProcessingException {
        ArrayList results = this.scanner.scan(text);
        if (results == null) {
            throw new ProcessingException("Problem encountered while running the component: " + this.getComponentName());
        }
        return results;
    }

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList chars = (ArrayList)o;
        int numChars = chars.size();
        InputFSArrayList result = new InputFSArrayList(numChars);
        for (int i = 0; i < numChars; ++i) {
            InputFeatureStructure fs = new InputFeatureStructure();
            AbstractScannerItem myChar = (AbstractScannerItem)chars.get(i);
            int start = myChar.getStart();
            int end = myChar.getEnd();
            fs.setPosition(start, end);
            String surface = new String(inputText, start, 1);
            short myLocalType = mapType[myChar.getType()];
            fs.setType(myLocalType);
            fs.initializeAttributes((byte)3);
            fs.setAttribute(2, surface);
            fs.setAttribute(0, myChar.getTypeAsString());
            fs.setAttribute(1, myChar.getSubTypeAsString());
            result.add(fs);
        }
        return result;
    }

    static {
        int numTypes = scannerTypes.length;
        for (int i = 0; i < numTypes; ++i) {
            scannerTypesList.add(scannerTypes[i]);
            ArrayList<String> attributesForType = new ArrayList<String>();
            int numAttributes = scannerAttrributes[i].length;
            for (int j = 0; j < numAttributes; ++j) {
                attributesForType.add(scannerAttrributes[i][j]);
            }
            scannerAttributeLists.put(scannerTypes[i], attributesForType);
        }
        BasicScanner.CharType[] bScannerTypes = BasicScanner.CharType.values();
        int numMappedTypes = bScannerTypes.length;
        mapType = new short[numMappedTypes];
        CorleoneBasicScanner.mapType[BasicScanner.CharType.UPPERCASE_LETTER.getCode()] = 0;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.LOWERCASE_LETTER.getCode()] = 0;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.TITLECASE_LETTER.getCode()] = 0;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER_LETTER.getCode()] = 0;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.LATIN_DIGIT.getCode()] = 1;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER_DIGIT.getCode()] = 1;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.NUMBER.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.CURRENCY_SYMBOL.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.MATH_SYMBOL.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.MODIFIER_SYMBOL.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER_SYMBOL.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.CONNECTOR_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.DASH_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.CLOSE_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OPEN_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.INITIAL_QUOTE_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.FINAL_QUOTE_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER_PUNCTUATION.getCode()] = 2;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.SPACE_SEPARATOR.getCode()] = 3;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER_SEPARATOR.getCode()] = 3;
        CorleoneBasicScanner.mapType[BasicScanner.CharType.OTHER.getCode()] = 4;
    }
}

